<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Zz Accounting</h4>
                </div>
                <div class="col-sm-3 ">
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("zz_accounting/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Zz Accounting 
                    </a>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('zz_accounting'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('zz_accounting'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('zz_accounting'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="zz_accounting-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-Job_Number"> Job Number</th>
                                                <th  class="td-Created_By"> Created By</th>
                                                <th  class="td-Created_TS"> Created Ts</th>
                                                <th  class="td-Paid"> Paid</th>
                                                <th  class="td-Paid_TS"> Paid Ts</th>
                                                <th  class="td-Invoiced"> Invoiced</th>
                                                <th  class="td-Note"> Note</th>
                                                <th  class="td-Updated_By"> Updated By</th>
                                                <th  class="td-Updated_TS"> Updated Ts</th>
                                                <th  class="td-Accounting_Received"> Accounting Received</th>
                                                <th  class="td-Accounting_Received_TS"> Accounting Received Ts</th>
                                                <th  class="td-Invoiced_TS"> Invoiced Ts</th>
                                                <th  class="td-Deposit_Required"> Deposit Required</th>
                                                <th  class="td-Deposit_Paid_TS"> Deposit Paid Ts</th>
                                                <th  class="td-Deposit_Paid"> Deposit Paid</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['Job_Number']) ? urlencode($data['Job_Number']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("zz_accounting/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("zz_accounting/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                    <a class="btn btn-sm btn-danger has-tooltip record-delete-btn" title="Delete this record" href="<?php print_link("zz_accounting/delete/$rec_id/?csrf_token=$csrf_token&redirect=$current_page"); ?>" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal">
                                                        <i class="icon dripicons-cross"></i>
                                                        Delete
                                                    </a>
                                                </th>
                                                <td class="td-Job_Number"><a href="<?php print_link("zz_accounting/view/$data[Job_Number]") ?>"><?php echo $data['Job_Number']; ?></a></td>
                                                <td class="td-Created_By">
                                                    <span  data-value="<?php echo $data['Created_By']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Created_By" 
                                                        data-title="Enter Created By" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Created_By']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Created_TS"> <?php echo $data['Created_TS']; ?></td>
                                                <td class="td-Paid">
                                                    <span  data-value="<?php echo $data['Paid']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Paid" 
                                                        data-title="Enter Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Paid']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Paid_TS">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Paid_TS']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Paid_TS" 
                                                        data-title="Enter Paid Ts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Paid_TS']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Invoiced">
                                                    <span  data-value="<?php echo $data['Invoiced']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Invoiced" 
                                                        data-title="Enter Invoiced" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Invoiced']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Note">
                                                    <span  data-value="<?php echo $data['Note']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Note" 
                                                        data-title="Enter Note" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Note']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Updated_By">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Updated_By']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Updated_By" 
                                                        data-title="Enter Updated By" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Updated_By']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Updated_TS">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Updated_TS']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Updated_TS" 
                                                        data-title="Enter Updated Ts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Updated_TS']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Accounting_Received">
                                                    <span  data-value="<?php echo $data['Accounting_Received']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Accounting_Received" 
                                                        data-title="Enter Accounting Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accounting_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Accounting_Received_TS">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Accounting_Received_TS']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Accounting_Received_TS" 
                                                        data-title="Enter Accounting Received Ts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accounting_Received_TS']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Invoiced_TS">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Invoiced_TS']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Invoiced_TS" 
                                                        data-title="Enter Invoiced Ts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Invoiced_TS']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Deposit_Required">
                                                    <span  data-value="<?php echo $data['Deposit_Required']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Deposit_Required" 
                                                        data-title="Enter Deposit Required" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Deposit_Required']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Deposit_Paid_TS">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Deposit_Paid_TS']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Deposit_Paid_TS" 
                                                        data-title="Enter Deposit Paid Ts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Deposit_Paid_TS']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Deposit_Paid">
                                                    <span  data-value="<?php echo $data['Deposit_Paid']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("zz_accounting/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Deposit_Paid" 
                                                        data-title="Enter Deposit Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Deposit_Paid']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                                <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("zz_accounting/delete/{sel_ids}/?csrf_token=$csrf_token&redirect=$current_page"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                    <i class="icon dripicons-cross"></i> Delete Selected
                                                </button>
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
