<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Accounting</h4>
                </div>
                <div class="col-sm-3 ">
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("accounting/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Accounting 
                    </a>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('accounting/'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('accounting'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('accounting'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="accounting-deposit_outstanding_list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-Paid"> Paid</th>
                                                <th  class="td-Invoiced"> Invoiced</th>
                                                <th  class="td-Note"> Note</th>
                                                <th  class="td-Updated_By"> Updated By</th>
                                                <th  class="td-Accounting_Received"> Accounting Received</th>
                                                <th  class="td-Job_Number"> Job Number</th>
                                                <th  class="td-Deposit_Required"> Deposit Required</th>
                                                <th  class="td-Deposit_Paid"> Deposit Paid</th>
                                                <th  class="td-DJobNum"> Job #</th>
                                                <th  class="td-joblist2015_JobNum"> Joblist2015 Jobnum</th>
                                                <th  class="td-joblist2015_Artisan"> Joblist2015 Artisan</th>
                                                <th  class="td-joblist2015_Dealer"> Joblist2015 Dealer</th>
                                                <th  class="td-joblist2015_CustomerNum"> Joblist2015 Customernum</th>
                                                <th  class="td-joblist2015_TagName"> Joblist2015 Tagname</th>
                                                <th  class="td-joblist2015_OrderEntry"> Joblist2015 Orderentry</th>
                                                <th  class="td-joblist2015_SalesRep"> Joblist2015 Salesrep</th>
                                                <th  class="td-joblist2015_RecdOrder"> Joblist2015 Recdorder</th>
                                                <th  class="td-joblist2015_StdLeadTime"> Joblist2015 Stdleadtime</th>
                                                <th  class="td-joblist2015_ReqDate"> Joblist2015 Reqdate</th>
                                                <th  class="td-joblist2015_Value"> Joblist2015 Value</th>
                                                <th  class="td-joblist2015_SentToOE"> Joblist2015 Senttooe</th>
                                                <th  class="td-joblist2015_SentToDealer"> Joblist2015 Senttodealer</th>
                                                <th  class="td-joblist2015_Confirmed"> Joblist2015 Confirmed</th>
                                                <th  class="td-joblist2015_SentToPlant"> Joblist2015 Senttoplant</th>
                                                <th  class="td-joblist2015_Inv"> Joblist2015 Inv</th>
                                                <th  class="td-joblist2015_Comments"> Joblist2015 Comments</th>
                                                <th  class="td-joblist2015_TimeStamp"> Joblist2015 Timestamp</th>
                                                <th  class="td-joblist2015_RSO"> Joblist2015 Rso</th>
                                                <th  class="td-joblist2015_Uppers"> Joblist2015 Uppers</th>
                                                <th  class="td-joblist2015_Talls"> Joblist2015 Talls</th>
                                                <th  class="td-joblist2015_Bases"> Joblist2015 Bases</th>
                                                <th  class="td-joblist2015_Vanities"> Joblist2015 Vanities</th>
                                                <th  class="td-joblist2015_Accessories"> Joblist2015 Accessories</th>
                                                <th  class="td-joblist2015_Wood"> Joblist2015 Wood</th>
                                                <th  class="td-joblist2015_Colour"> Joblist2015 Colour</th>
                                                <th  class="td-joblist2015_DoorVendor"> Joblist2015 Doorvendor</th>
                                                <th  class="td-joblist2015_DoorETA"> Joblist2015 Dooreta</th>
                                                <th  class="td-joblist2015_OtherETA"> Joblist2015 Othereta</th>
                                                <th  class="td-joblist2015_Priority"> Joblist2015 Priority</th>
                                                <th  class="td-joblist2015_Creator"> Joblist2015 Creator</th>
                                                <th  class="td-joblist2015_DoorStyle"> Joblist2015 Doorstyle</th>
                                                <th  class="td-joblist2015_Conf_Rec"> Joblist2015 Conf Rec</th>
                                                <th  class="td-joblist2015_NJobNum"> Joblist2015 Njobnum</th>
                                                <th  class="td-joblist2015_DateShipped"> Joblist2015 Dateshipped</th>
                                                <th  class="td-joblist2015_BackOrders"> Joblist2015 Backorders</th>
                                                <th  class="td-joblist2015_BackOrdersShipped"> Joblist2015 Backordersshipped</th>
                                                <th  class="td-joblist2015_propshipdate"> Joblist2015 Propshipdate</th>
                                                <th  class="td-joblist2015_shipcomments"> Joblist2015 Shipcomments</th>
                                                <th  class="td-joblist2015_shipdetails"> Joblist2015 Shipdetails</th>
                                                <th  class="td-joblist2015_DealerRoute"> Joblist2015 Dealerroute</th>
                                                <th  class="td-joblist2015_OrgJobNum"> Joblist2015 Orgjobnum</th>
                                                <th  class="td-joblist2015_UpdatedBy"> Joblist2015 Updatedby</th>
                                                <th  class="td-joblist2015_LastUpdated"> Joblist2015 Lastupdated</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['Job_Number']) ? urlencode($data['Job_Number']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <td class="td-Paid">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['Paid']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Paid" 
                                                        data-title="Enter Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Paid']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Invoiced">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['Invoiced']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Invoiced" 
                                                        data-title="Enter Invoiced" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Invoiced']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Note">
                                                    <span  data-source='<?php print_link('api/json/accounting_Note_option_list'); ?>' 
                                                        data-value="<?php echo $data['Note']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Note" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Note']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Updated_By"> <?php echo $data['Updated_By']; ?></td>
                                                <td class="td-Accounting_Received">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['Accounting_Received']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Accounting_Received" 
                                                        data-title="Enter Accounting Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accounting_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Job_Number"> <?php echo $data['Job_Number']; ?></td>
                                                <td class="td-Deposit_Required">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['Deposit_Required']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Deposit_Required" 
                                                        data-title="Enter Deposit Required" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Deposit_Required']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Deposit_Paid">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['Deposit_Paid']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Deposit_Paid" 
                                                        data-title="Enter Deposit Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Deposit_Paid']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-DJobNum"> <?php echo $data['DJobNum']; ?></td>
                                                <td class="td-joblist2015_JobNum"> <?php echo $data['joblist2015_JobNum']; ?></td>
                                                <td class="td-joblist2015_Artisan">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['joblist2015_Artisan']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Artisan" 
                                                        data-title="To Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Artisan']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_Dealer"> <?php echo $data['joblist2015_Dealer']; ?></td>
                                                <td class="td-joblist2015_CustomerNum"> <?php echo $data['joblist2015_CustomerNum']; ?></td>
                                                <td class="td-joblist2015_TagName"> <?php echo $data['joblist2015_TagName']; ?></td>
                                                <td class="td-joblist2015_OrderEntry"> <?php echo $data['joblist2015_OrderEntry']; ?></td>
                                                <td class="td-joblist2015_SalesRep"> <?php echo $data['joblist2015_SalesRep']; ?></td>
                                                <td class="td-joblist2015_RecdOrder"> <?php echo $data['joblist2015_RecdOrder']; ?></td>
                                                <td class="td-joblist2015_StdLeadTime"> <?php echo $data['joblist2015_StdLeadTime']; ?></td>
                                                <td class="td-joblist2015_ReqDate"> <?php echo $data['joblist2015_ReqDate']; ?></td>
                                                <td class="td-joblist2015_Value">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['joblist2015_Value']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Value']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_SentToOE"> <?php echo $data['joblist2015_SentToOE']; ?></td>
                                                <td class="td-joblist2015_SentToDealer">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['joblist2015_SentToDealer']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="SentToDealer" 
                                                        data-title="Enter Senttodealer" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_SentToDealer']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_Confirmed">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['joblist2015_Confirmed']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Confirmed" 
                                                        data-title="Enter Confirmed" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Confirmed']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_SentToPlant">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['joblist2015_SentToPlant']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="SentToPlant" 
                                                        data-title="Enter Senttoplant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_SentToPlant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_Inv">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['joblist2015_Inv']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Inv" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Inv']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_Comments">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Comments" 
                                                        data-title="Enter Comments" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Comments']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_TimeStamp"> <?php echo $data['joblist2015_TimeStamp']; ?></td>
                                                <td class="td-joblist2015_RSO"> <?php echo $data['joblist2015_RSO']; ?></td>
                                                <td class="td-joblist2015_Uppers"> <?php echo $data['joblist2015_Uppers']; ?></td>
                                                <td class="td-joblist2015_Talls"> <?php echo $data['joblist2015_Talls']; ?></td>
                                                <td class="td-joblist2015_Bases"> <?php echo $data['joblist2015_Bases']; ?></td>
                                                <td class="td-joblist2015_Vanities"> <?php echo $data['joblist2015_Vanities']; ?></td>
                                                <td class="td-joblist2015_Accessories"> <?php echo $data['joblist2015_Accessories']; ?></td>
                                                <td class="td-joblist2015_Wood">
                                                    <span  data-source='<?php print_link('api/json/accounting_joblist2015_Wood_option_list'); ?>' 
                                                        data-value="<?php echo $data['joblist2015_Wood']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Wood" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Wood']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_Colour">
                                                    <span  data-source='<?php print_link('api/json/accounting_joblist2015_Colour_option_list'); ?>' 
                                                        data-value="<?php echo $data['joblist2015_Colour']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Colour']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_DoorVendor">
                                                    <span  data-source='<?php print_link('api/json/accounting_joblist2015_DoorVendor_option_list'); ?>' 
                                                        data-value="<?php echo $data['joblist2015_DoorVendor']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="DoorVendor" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_DoorVendor']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_DoorETA"> <?php echo $data['joblist2015_DoorETA']; ?></td>
                                                <td class="td-joblist2015_OtherETA"> <?php echo $data['joblist2015_OtherETA']; ?></td>
                                                <td class="td-joblist2015_Priority"> <?php echo $data['joblist2015_Priority']; ?></td>
                                                <td class="td-joblist2015_Creator"> <?php echo $data['joblist2015_Creator']; ?></td>
                                                <td class="td-joblist2015_DoorStyle">
                                                    <span  data-source='<?php print_link('api/json/accounting_joblist2015_DoorStyle_option_list'); ?>' 
                                                        data-value="<?php echo $data['joblist2015_DoorStyle']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="DoorStyle" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_DoorStyle']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_Conf_Rec">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['joblist2015_Conf_Rec']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Conf_Rec" 
                                                        data-title="Enter Conf Rec" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_Conf_Rec']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_NJobNum">
                                                    <span  data-source='<?php print_link('api/json/accounting_joblist2015_NJobNum_option_list'); ?>' 
                                                        data-value="<?php echo $data['joblist2015_NJobNum']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="NJobNum" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_NJobNum']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-joblist2015_DateShipped"> <?php echo $data['joblist2015_DateShipped']; ?></td>
                                                <td class="td-joblist2015_BackOrders"> <?php echo $data['joblist2015_BackOrders']; ?></td>
                                                <td class="td-joblist2015_BackOrdersShipped"> <?php echo $data['joblist2015_BackOrdersShipped']; ?></td>
                                                <td class="td-joblist2015_propshipdate"> <?php echo $data['joblist2015_propshipdate']; ?></td>
                                                <td class="td-joblist2015_shipcomments"> <?php echo $data['joblist2015_shipcomments']; ?></td>
                                                <td class="td-joblist2015_shipdetails"> <?php echo $data['joblist2015_shipdetails']; ?></td>
                                                <td class="td-joblist2015_DealerRoute"> <?php echo $data['joblist2015_DealerRoute']; ?></td>
                                                <td class="td-joblist2015_OrgJobNum"> <?php echo $data['joblist2015_OrgJobNum']; ?></td>
                                                <td class="td-joblist2015_UpdatedBy"> <?php echo $data['joblist2015_UpdatedBy']; ?></td>
                                                <td class="td-joblist2015_LastUpdated">
                                                    <span  data-value="<?php echo $data['joblist2015_LastUpdated']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="LastUpdated" 
                                                        data-title="Enter Lastupdated" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['joblist2015_LastUpdated']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> Currently there are No Jobs sent to Accounting that don't need a deposit.
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
