<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Joblist2015</h4>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('joblist2015'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('joblist2015'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('joblist2015'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="joblist2015-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-JobNum"> Jobnum</th>
                                                <th  class="td-Artisan"> Artisan</th>
                                                <th  class="td-Dealer"> Dealer</th>
                                                <th  class="td-CustomerNum"> Customernum</th>
                                                <th  class="td-TagName"> Tagname</th>
                                                <th  class="td-OrderEntry"> Orderentry</th>
                                                <th  class="td-SalesRep"> Salesrep</th>
                                                <th  class="td-RecdOrder"> Recdorder</th>
                                                <th  class="td-StdLeadTime"> Stdleadtime</th>
                                                <th  class="td-ReqDate"> Reqdate</th>
                                                <th  class="td-Value"> Value</th>
                                                <th  class="td-SentToOE"> Senttooe</th>
                                                <th  class="td-SentToDealer"> Senttodealer</th>
                                                <th  class="td-Confirmed"> Confirmed</th>
                                                <th  class="td-SentToPlant"> Senttoplant</th>
                                                <th  class="td-Inv"> Inv</th>
                                                <th  class="td-Comments"> Comments</th>
                                                <th  class="td-TimeStamp"> Timestamp</th>
                                                <th  class="td-RSO"> Rso</th>
                                                <th  class="td-Uppers"> Uppers</th>
                                                <th  class="td-Talls"> Talls</th>
                                                <th  class="td-Bases"> Bases</th>
                                                <th  class="td-Vanities"> Vanities</th>
                                                <th  class="td-Accessories"> Accessories</th>
                                                <th  class="td-Wood"> Wood</th>
                                                <th  class="td-Colour"> Colour</th>
                                                <th  class="td-DoorVendor"> Doorvendor</th>
                                                <th  class="td-DoorETA"> Dooreta</th>
                                                <th  class="td-OtherETA"> Othereta</th>
                                                <th  class="td-Priority"> Priority</th>
                                                <th  class="td-Creator"> Creator</th>
                                                <th  class="td-DoorStyle"> Doorstyle</th>
                                                <th  class="td-Conf_Rec"> Conf Rec</th>
                                                <th  class="td-NJobNum"> Njobnum</th>
                                                <th  class="td-DateShipped"> Dateshipped</th>
                                                <th  class="td-BackOrders"> Backorders</th>
                                                <th  class="td-BackOrdersShipped"> Backordersshipped</th>
                                                <th  class="td-propshipdate"> Propshipdate</th>
                                                <th  class="td-shipcomments"> Shipcomments</th>
                                                <th  class="td-shipdetails"> Shipdetails</th>
                                                <th  class="td-DealerRoute"> Dealerroute</th>
                                                <th  class="td-OrgJobNum"> Orgjobnum</th>
                                                <th  class="td-UpdatedBy"> Updatedby</th>
                                                <th  class="td-LastUpdated"> Lastupdated</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['JobNum']) ? urlencode($data['JobNum']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("joblist2015/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("joblist2015/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                </th>
                                                <td class="td-JobNum"><a href="<?php print_link("joblist2015/view/$data[JobNum]") ?>"><?php echo $data['JobNum']; ?></a></td>
                                                <td class="td-Artisan">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['Artisan']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Artisan" 
                                                        data-title="To Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Artisan']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Dealer"> <?php echo $data['Dealer']; ?></td>
                                                <td class="td-CustomerNum"> <?php echo $data['CustomerNum']; ?></td>
                                                <td class="td-TagName"> <?php echo $data['TagName']; ?></td>
                                                <td class="td-OrderEntry"> <?php echo $data['OrderEntry']; ?></td>
                                                <td class="td-SalesRep"> <?php echo $data['SalesRep']; ?></td>
                                                <td class="td-RecdOrder"> <?php echo $data['RecdOrder']; ?></td>
                                                <td class="td-StdLeadTime"> <?php echo $data['StdLeadTime']; ?></td>
                                                <td class="td-ReqDate"> <?php echo $data['ReqDate']; ?></td>
                                                <td class="td-Value">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['Value']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Value']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-SentToOE"> <?php echo $data['SentToOE']; ?></td>
                                                <td class="td-SentToDealer">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['SentToDealer']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="SentToDealer" 
                                                        data-title="Enter Senttodealer" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['SentToDealer']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Confirmed">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Confirmed']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Confirmed" 
                                                        data-title="Enter Confirmed" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Confirmed']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-SentToPlant">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['SentToPlant']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="SentToPlant" 
                                                        data-title="Enter Senttoplant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['SentToPlant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Inv">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['Inv']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Inv" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Inv']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Comments">
                                                    <span  data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Comments" 
                                                        data-title="Enter Comments" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Comments']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-TimeStamp"> <?php echo $data['TimeStamp']; ?></td>
                                                <td class="td-RSO"> <?php echo $data['RSO']; ?></td>
                                                <td class="td-Uppers"> <?php echo $data['Uppers']; ?></td>
                                                <td class="td-Talls"> <?php echo $data['Talls']; ?></td>
                                                <td class="td-Bases"> <?php echo $data['Bases']; ?></td>
                                                <td class="td-Vanities"> <?php echo $data['Vanities']; ?></td>
                                                <td class="td-Accessories"> <?php echo $data['Accessories']; ?></td>
                                                <td class="td-Wood">
                                                    <span  data-source='<?php print_link('api/json/joblist2015_Wood_option_list'); ?>' 
                                                        data-value="<?php echo $data['Wood']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Wood" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Wood']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Colour">
                                                    <span  data-source='<?php print_link('api/json/joblist2015_Colour_option_list'); ?>' 
                                                        data-value="<?php echo $data['Colour']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Colour']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-DoorVendor">
                                                    <span  data-source='<?php print_link('api/json/joblist2015_DoorVendor_option_list'); ?>' 
                                                        data-value="<?php echo $data['DoorVendor']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="DoorVendor" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['DoorVendor']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-DoorETA"> <?php echo $data['DoorETA']; ?></td>
                                                <td class="td-OtherETA"> <?php echo $data['OtherETA']; ?></td>
                                                <td class="td-Priority"> <?php echo $data['Priority']; ?></td>
                                                <td class="td-Creator"> <?php echo $data['Creator']; ?></td>
                                                <td class="td-DoorStyle">
                                                    <span  data-source='<?php print_link('api/json/joblist2015_DoorStyle_option_list'); ?>' 
                                                        data-value="<?php echo $data['DoorStyle']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="DoorStyle" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['DoorStyle']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Conf_Rec">
                                                    <span  data-flatpickr="{ minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Conf_Rec']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Conf_Rec" 
                                                        data-title="Enter Conf Rec" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Conf_Rec']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-NJobNum">
                                                    <span  data-source='<?php print_link('api/json/joblist2015_NJobNum_option_list'); ?>' 
                                                        data-value="<?php echo $data['NJobNum']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="NJobNum" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['NJobNum']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-DateShipped"> <?php echo $data['DateShipped']; ?></td>
                                                <td class="td-BackOrders"> <?php echo $data['BackOrders']; ?></td>
                                                <td class="td-BackOrdersShipped"> <?php echo $data['BackOrdersShipped']; ?></td>
                                                <td class="td-propshipdate"> <?php echo $data['propshipdate']; ?></td>
                                                <td class="td-shipcomments"> <?php echo $data['shipcomments']; ?></td>
                                                <td class="td-shipdetails"> <?php echo $data['shipdetails']; ?></td>
                                                <td class="td-DealerRoute"> <?php echo $data['DealerRoute']; ?></td>
                                                <td class="td-OrgJobNum"> <?php echo $data['OrgJobNum']; ?></td>
                                                <td class="td-UpdatedBy"> <?php echo $data['UpdatedBy']; ?></td>
                                                <td class="td-LastUpdated">
                                                    <span  data-value="<?php echo $data['LastUpdated']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="LastUpdated" 
                                                        data-title="Enter Lastupdated" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['LastUpdated']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
