<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Jobs Sent to Plant without an Invoiced date.</h4>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('joblist2015/'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('joblist2015'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('joblist2015'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="joblist2015-list_join-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  <?php echo (get_value('orderby')=='JobNum' ? 'class="sortedby td-JobNum"' : null); ?>>
                                                    <?php Html :: get_field_order_link('JobNum', "Job Number"); ?>
                                                </th>
                                                <th  <?php echo (get_value('orderby')=='Dealer' ? 'class="sortedby td-Dealer"' : null); ?>>
                                                    <?php Html :: get_field_order_link('Dealer', "Dealer"); ?>
                                                </th>
                                                <th  class="td-TagName"> Tagname</th>
                                                <th  class="td-OrderEntry"> OE Person</th>
                                                <th  <?php echo (get_value('orderby')=='Value' ? 'class="sortedby td-Value"' : null); ?>>
                                                    <?php Html :: get_field_order_link('Value', "Value"); ?>
                                                </th>
                                                <th  <?php echo (get_value('orderby')=='SentToPlant' ? 'class="sortedby td-SentToPlant"' : null); ?>>
                                                    <?php Html :: get_field_order_link('SentToPlant', "Senttoplant"); ?>
                                                </th>
                                                <th  <?php echo (get_value('orderby')=='DateShipped' ? 'class="sortedby td-DateShipped"' : null); ?>>
                                                    <?php Html :: get_field_order_link('DateShipped', "Date Shipped"); ?>
                                                </th>
                                                <th  class="td-Inv"> Invoiced date</th>
                                                <th  class="td-accounting_Paid"> Accounting Paid</th>
                                                <th  class="td-accounting_Invoiced"> Accounting Invoiced</th>
                                                <th  class="td-accounting_Note"> Accounting Note</th>
                                                <th  class="td-accounting_Updated_By"> Accounting Updated By</th>
                                                <th  class="td-accounting_Accounting_Received"> Accounting Accounting Received</th>
                                                <th  class="td-accounting_Created_TS"> Accounting Created Ts</th>
                                                <th  class="td-accounting_Paid_TS"> Accounting Paid Ts</th>
                                                <th  class="td-accounting_Updated_TS"> Accounting Updated Ts</th>
                                                <th  class="td-accounting_Accounting_Received_TS"> Accounting Accounting Received Ts</th>
                                                <th  class="td-accounting_Invoiced_TS"> Accounting Invoiced Ts</th>
                                                <th  class="td-accounting_Deposit_Required"> Accounting Deposit Required</th>
                                                <th  class="td-accounting_Deposit_Paid_TS"> Accounting Deposit Paid Ts</th>
                                                <th  class="td-accounting_Deposit_Paid"> Accounting Deposit Paid</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['JobNum']) ? urlencode($data['JobNum']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("joblist2015/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                </th>
                                                <td class="td-JobNum"> <?php echo $data['JobNum']; ?></td>
                                                <td class="td-Dealer"> <?php echo $data['Dealer']; ?></td>
                                                <td class="td-TagName"> <?php echo $data['TagName']; ?></td>
                                                <td class="td-OrderEntry"> <?php echo $data['OrderEntry']; ?></td>
                                                <td class="td-Value">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['Value']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("joblist2015/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Value']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-SentToPlant"> <?php echo $data['SentToPlant']; ?></td>
                                                <td class="td-DateShipped"> <?php echo $data['DateShipped']; ?></td>
                                                <td class="td-Inv"> <?php echo $data['Inv']; ?></td>
                                                <td class="td-accounting_Paid">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['accounting_Paid']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Paid" 
                                                        data-title="Enter Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Paid']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Invoiced">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['accounting_Invoiced']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Invoiced" 
                                                        data-title="Enter Invoiced" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Invoiced']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Note">
                                                    <span  data-source='<?php print_link('api/json/joblist2015_accounting_Note_option_list'); ?>' 
                                                        data-value="<?php echo $data['accounting_Note']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Note" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Note']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Updated_By"> <?php echo $data['accounting_Updated_By']; ?></td>
                                                <td class="td-accounting_Accounting_Received">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['accounting_Accounting_Received']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Accounting_Received" 
                                                        data-title="Enter Accounting Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Accounting_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Created_TS"> <?php echo $data['accounting_Created_TS']; ?></td>
                                                <td class="td-accounting_Paid_TS"> <?php echo $data['accounting_Paid_TS']; ?></td>
                                                <td class="td-accounting_Updated_TS"> <?php echo $data['accounting_Updated_TS']; ?></td>
                                                <td class="td-accounting_Accounting_Received_TS"> <?php echo $data['accounting_Accounting_Received_TS']; ?></td>
                                                <td class="td-accounting_Invoiced_TS"> <?php echo $data['accounting_Invoiced_TS']; ?></td>
                                                <td class="td-accounting_Deposit_Required">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['accounting_Deposit_Required']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Deposit_Required" 
                                                        data-title="Enter Deposit Required" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Deposit_Required']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-accounting_Deposit_Paid_TS"> <?php echo $data['accounting_Deposit_Paid_TS']; ?></td>
                                                <td class="td-accounting_Deposit_Paid">
                                                    <span  data-source='[{value: "Y", label: "Yes"},{value: "No", label: "No"}]' 
                                                        data-value="<?php echo $data['accounting_Deposit_Paid']; ?>" 
                                                        data-pk="<?php echo $data['JobNum'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Deposit_Paid" 
                                                        data-title="Enter Deposit Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['accounting_Deposit_Paid']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
