<?php 
/**
 * Accounting Page Controller
 * @category  Controller
 */
class AccountingController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "accounting";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Created_By", 
			"Paid", 
			"Invoiced", 
			"Note", 
			"Updated_By", 
			"Accounting_Received", 
			"Job_Number", 
			"Deposit_Required", 
			"Deposit_Paid");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "accounting/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("accounting.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting";
		$view_name = (is_ajax() ? "accounting/ajax-list.php" : "accounting/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("accounting.Created_By", 
			"accounting.Paid", 
			"accounting.Invoiced", 
			"accounting.Note", 
			"accounting.Accounting_Received", 
			"accounting.Job_Number", 
			"accounting.Deposit_Required", 
			"accounting.Deposit_Paid", 
			"joblist2015.Artisan AS joblist2015_Artisan", 
			"joblist2015.Dealer AS joblist2015_Dealer", 
			"joblist2015.CustomerNum AS joblist2015_CustomerNum", 
			"joblist2015.TagName AS joblist2015_TagName", 
			"joblist2015.Value AS joblist2015_Value", 
			"joblist2015.Confirmed AS joblist2015_Confirmed", 
			"joblist2015.Comments AS joblist2015_Comments");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("accounting.Job_Number", $rec_id);; //select record based on primary key
		}
		$db->join("joblist2015", "accounting.Job_Number = joblist2015.JobNum", "RIGHT ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Accounting";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("accounting/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Created_By","Paid","Invoiced","Note","Accounting_Received","Job_Number","Created_TS","Deposit_Required","Deposit_Paid");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Number' => 'required',
			);
			$this->sanitize_array = array(
				'Created_By' => 'sanitize_string',
				'Paid' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Accounting_Received' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Created_TS' => 'sanitize_string',
				'Deposit_Required' => 'sanitize_string',
				'Deposit_Paid' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			//Check if Duplicate Record Already Exit In The Database
			$db->where("Job_Number", $modeldata['Job_Number']);
			if($db->has($tablename)){
				$this->view->page_error[] = $modeldata['Job_Number']." Already exist!";
			} 
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("accounting/edit/$rec_id");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add to Accounting";
		$this->render_view("accounting/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Paid","Invoiced","Note","Accounting_Received","Deposit_Required","Deposit_Paid");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
			);
			$this->sanitize_array = array(
				'Paid' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Accounting_Received' => 'sanitize_string',
				'Deposit_Required' => 'sanitize_string',
				'Deposit_Paid' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("accounting.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("accounting");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("accounting");
					}
				}
			}
		}
		$db->where("accounting.Job_Number", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Accounting Info";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("accounting/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Paid","Invoiced","Note","Accounting_Received","Deposit_Required","Deposit_Paid");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
			);
			$this->sanitize_array = array(
				'Paid' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Note' => 'sanitize_string',
				'Accounting_Received' => 'sanitize_string',
				'Deposit_Required' => 'sanitize_string',
				'Deposit_Paid' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("accounting.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function deposit_outstanding_list($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM JobNum)))) AS DJobNum", 
			"accounting.Paid", 
			"accounting.Invoiced", 
			"accounting.Note", 
			"accounting.Updated_By", 
			"accounting.Accounting_Received", 
			"accounting.Job_Number", 
			"accounting.Deposit_Required", 
			"accounting.Deposit_Paid", 
			"joblist2015.JobNum AS joblist2015_JobNum", 
			"joblist2015.Dealer AS joblist2015_Dealer", 
			"joblist2015.CustomerNum AS joblist2015_CustomerNum", 
			"joblist2015.TagName AS joblist2015_TagName", 
			"joblist2015.Inv AS joblist2015_Inv", 
			"joblist2015.Comments AS joblist2015_Comments", 
			"joblist2015.LastUpdated AS joblist2015_LastUpdated");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				accounting.DJobNum LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "accounting/search.php";
		}
		$db->join("joblist2015", "accounting.Job_Number = joblist2015.JobNum", "INNER");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("accounting.Job_Number", ORDER_TYPE);
		}
		$db->where("Deposit_Required = 'Y' AND Deposit_Paid !='Y'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting";
		$view_name = (is_ajax() ? "accounting/ajax-deposit_outstanding_list.php" : "accounting/deposit_outstanding_list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function not_in_accounting($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(`Job_`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `Job_`.jobnum)))) AS DJobNum", 
			"accounting.Created_By", 
			"accounting.Paid", 
			"accounting.Invoiced", 
			"accounting.Note", 
			"accounting.Updated_By", 
			"accounting.Accounting_Received", 
			"accounting.Job_Number", 
			"accounting.Deposit_Required", 
			"accounting.Deposit_Paid", 
			"Job_.Artisan AS Job", 
			"Job_.Dealer AS Job", 
			"Job_.CustomerNum AS Job", 
			"Job_.TagName AS Job", 
			"Job_.OrderEntry AS Job", 
			"Job_.Value AS Job", 
			"Job_.Confirmed AS Job", 
			"Job_.Conf_Rec AS Job_Rec", 
			"Job_.DateShipped AS Job", 
			"Job_.LastUpdated AS Job");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				accounting.DJobNum LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				Job_.JobNum LIKE ? OR 
				Job_.Artisan LIKE ? OR 
				Job_.Dealer LIKE ? OR 
				Job_.CustomerNum LIKE ? OR 
				Job_.TagName LIKE ? OR 
				Job_.OrderEntry LIKE ? OR 
				Job_.SalesRep LIKE ? OR 
				Job_.RecdOrder LIKE ? OR 
				Job_.StdLeadTime LIKE ? OR 
				Job_.ReqDate LIKE ? OR 
				Job_.Value LIKE ? OR 
				Job_.SentToOE LIKE ? OR 
				Job_.SentToDealer LIKE ? OR 
				Job_.Confirmed LIKE ? OR 
				Job_.SentToPlant LIKE ? OR 
				Job_.Inv LIKE ? OR 
				Job_.Comments LIKE ? OR 
				Job_.TimeStamp LIKE ? OR 
				Job_.RSO LIKE ? OR 
				Job_.Uppers LIKE ? OR 
				Job_.Talls LIKE ? OR 
				Job_.Bases LIKE ? OR 
				Job_.Vanities LIKE ? OR 
				Job_.Accessories LIKE ? OR 
				Job_.Wood LIKE ? OR 
				Job_.Colour LIKE ? OR 
				Job_.DoorVendor LIKE ? OR 
				Job_.DoorETA LIKE ? OR 
				Job_.OtherETA LIKE ? OR 
				Job_.Priority LIKE ? OR 
				Job_.Creator LIKE ? OR 
				Job_.DoorStyle LIKE ? OR 
				Job_.Conf_Rec LIKE ? OR 
				Job_.NJobNum LIKE ? OR 
				Job_.DateShipped LIKE ? OR 
				Job_.BackOrders LIKE ? OR 
				Job_.BackOrdersShipped LIKE ? OR 
				Job_.propshipdate LIKE ? OR 
				Job_.shipcomments LIKE ? OR 
				Job_.shipdetails LIKE ? OR 
				Job_.DealerRoute LIKE ? OR 
				Job_.OrgJobNum LIKE ? OR 
				Job_.UpdatedBy LIKE ? OR 
				Job_.LastUpdated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "accounting/search.php";
		}
		$db->join("joblist2015 AS Job_", "accounting.Job_Number = Job_.JobNum", "RIGHT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("accounting.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting";
		$view_name = (is_ajax() ? "accounting/ajax-not_in_accounting.php" : "accounting/not_in_accounting.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function nia($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(`joblist2015`.NJobNum,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `joblist2015`.jobnum)))) AS DJobNum", 
			"accounting.Created_By", 
			"accounting.Paid", 
			"accounting.Invoiced", 
			"accounting.Note", 
			"accounting.Job_Number", 
			"joblist2015.JobNum AS joblist2015_JobNum", 
			"joblist2015.Artisan AS joblist2015_Artisan", 
			"joblist2015.Dealer AS joblist2015_Dealer", 
			"joblist2015.CustomerNum AS joblist2015_CustomerNum", 
			"joblist2015.TagName AS joblist2015_TagName", 
			"joblist2015.OrderEntry AS joblist2015_OrderEntry", 
			"joblist2015.Confirmed AS joblist2015_Confirmed", 
			"joblist2015.Inv AS joblist2015_Inv", 
			"joblist2015.Comments AS joblist2015_Comments", 
			"joblist2015.LastUpdated AS joblist2015_LastUpdated");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				accounting.DJobNum LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ? OR 
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "accounting/search.php";
		}
		$db->join("joblist2015", "accounting.Job_Number = joblist2015.JobNum", "RIGHT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("accounting.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Accounting";
		$view_name = (is_ajax() ? "accounting/ajax-nia.php" : "accounting/nia.php");
		$this->render_view($view_name, $data);
	}
}
