<?php 
/**
 * Artisan_production Page Controller
 * @category  Controller
 */
class Artisan_productionController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "artisan_production";
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("JobNum","BOs","DOORS","TRUCKLIST","CUTLIST","SAW","ROVER","BOOTH");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'JobNum' => 'numeric',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'BOs' => 'sanitize_string',
				'DOORS' => 'sanitize_string',
				'TRUCKLIST' => 'sanitize_string',
				'CUTLIST' => 'sanitize_string',
				'SAW' => 'sanitize_string',
				'ROVER' => 'sanitize_string',
				'BOOTH' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("artisan_production.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
