<?php 
/**
 * Joblist2015 Page Controller
 * @category  Controller
 */
class Joblist2015Controller extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "joblist2015";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Artisan", 
			"Dealer", 
			"CustomerNum", 
			"TagName", 
			"OrderEntry", 
			"SalesRep", 
			"RecdOrder", 
			"StdLeadTime", 
			"ReqDate", 
			"Value", 
			"SentToOE", 
			"SentToDealer", 
			"Confirmed", 
			"SentToPlant", 
			"Inv", 
			"Comments", 
			"TimeStamp", 
			"RSO", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Wood", 
			"Colour", 
			"DoorVendor", 
			"DoorETA", 
			"OtherETA", 
			"Priority", 
			"Creator", 
			"DoorStyle", 
			"Conf_Rec", 
			"NJobNum", 
			"DateShipped", 
			"BackOrders", 
			"BackOrdersShipped", 
			"propshipdate", 
			"shipcomments", 
			"shipdetails", 
			"DealerRoute", 
			"OrgJobNum", 
			"UpdatedBy", 
			"LastUpdated");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("joblist2015.JobNum", ORDER_TYPE);
		}
		$db->where("INV < '2021-05-04' AND `SentToPlant` > '2021-05-05'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Jobs For Accounting";
		$view_name = (is_ajax() ? "joblist2015/ajax-list.php" : "joblist2015/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("joblist2015.JobNum", 
			"joblist2015.Artisan", 
			"joblist2015.Dealer", 
			"joblist2015.CustomerNum", 
			"joblist2015.TagName", 
			"joblist2015.OrderEntry", 
			"joblist2015.SalesRep", 
			"joblist2015.RecdOrder", 
			"joblist2015.StdLeadTime", 
			"joblist2015.ReqDate", 
			"joblist2015.Value", 
			"joblist2015.SentToOE", 
			"joblist2015.SentToDealer", 
			"joblist2015.Confirmed", 
			"joblist2015.SentToPlant", 
			"joblist2015.Inv", 
			"joblist2015.Comments", 
			"joblist2015.TimeStamp", 
			"joblist2015.RSO", 
			"joblist2015.Uppers", 
			"joblist2015.Talls", 
			"joblist2015.Bases", 
			"joblist2015.Vanities", 
			"joblist2015.Accessories", 
			"joblist2015.Wood", 
			"joblist2015.Colour", 
			"joblist2015.DoorVendor", 
			"joblist2015.DoorETA", 
			"joblist2015.OtherETA", 
			"joblist2015.Priority", 
			"joblist2015.Creator", 
			"joblist2015.DoorStyle", 
			"joblist2015.Conf_Rec", 
			"joblist2015.NJobNum", 
			"joblist2015.DateShipped", 
			"joblist2015.BackOrders", 
			"joblist2015.BackOrdersShipped", 
			"joblist2015.propshipdate", 
			"joblist2015.shipcomments", 
			"joblist2015.shipdetails", 
			"joblist2015.DealerRoute", 
			"joblist2015.OrgJobNum", 
			"joblist2015.UpdatedBy", 
			"joblist2015.LastUpdated", 
			"accounting.JobNum AS accounting_JobNum", 
			"accounting.Created_By AS accounting_Created_By", 
			"accounting.Time_Created AS accounting_Time_Created", 
			"accounting.Paid AS accounting_Paid", 
			"accounting.Time_Paid AS accounting_Time_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Note AS accounting_Note", 
			"accounting.Updated_By AS accounting_Updated_By", 
			"accounting.Updated AS accounting_Updated", 
			"accounting.Time_Accounting_Received AS accounting_Time_Accounting_Received", 
			"accounting.Accounting_Received AS accounting_Accounting_Received");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("joblist2015.JobNum", $rec_id);; //select record based on primary key
		}
		$db->join("accounting", "joblist2015.JobNum = accounting.JobNum", "LEFT ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Job List";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("joblist2015/view.php", $record);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("JobNum","Value","Inv");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Value' => 'numeric',
			);
			$this->sanitize_array = array(
				'Value' => 'sanitize_string',
				'Inv' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("joblist2015.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function list_join($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("joblist2015.NJobNum", 
			"joblist2015.JobNum", 
			"joblist2015.Dealer", 
			"joblist2015.TagName", 
			"joblist2015.OrderEntry", 
			"joblist2015.Value", 
			"joblist2015.SentToPlant", 
			"joblist2015.DateShipped", 
			"joblist2015.Inv", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"accounting.Paid AS accounting_Paid", 
			"accounting.Note AS accounting_Note");
		$pagination = $this->get_pagination(20); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ? OR 
				accounting.JobNum LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Time_Created LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Time_Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Updated LIKE ? OR 
				accounting.Time_Accounting_Received LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		$db->join("accounting", "joblist2015.JobNum = accounting.JobNum", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("joblist2015.JobNum", ORDER_TYPE);
		}
		$db->where("INV < '2021-05-04' AND `SentToPlant` > '2021-05-05'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Jobs For Accounting";
		$view_name = (is_ajax() ? "joblist2015/ajax-list_join.php" : "joblist2015/list_join.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function jobs_to_receive($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Dealer", 
			"TagName", 
			"OrderEntry", 
			"Value", 
			"SentToPlant", 
			"Inv", 
			"Comments");
		$pagination = $this->get_pagination(20); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("joblist2015.JobNum", ORDER_TYPE);
		}
		$db->where("INV < '2021-05-04' AND `SentToPlant` > '2021-05-05'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Jobs to Look For";
		$this->render_view("joblist2015/jobs_to_receive.php", $data); //render the full page
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function list_4_acc($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Artisan", 
			"Dealer", 
			"CustomerNum", 
			"TagName", 
			"OrderEntry", 
			"SalesRep", 
			"RecdOrder", 
			"StdLeadTime", 
			"ReqDate", 
			"Value", 
			"SentToOE", 
			"SentToDealer", 
			"Confirmed", 
			"SentToPlant", 
			"Inv", 
			"Comments", 
			"TimeStamp", 
			"RSO", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Wood", 
			"Colour", 
			"DoorVendor", 
			"DoorETA", 
			"OtherETA", 
			"Priority", 
			"Creator", 
			"DoorStyle", 
			"Conf_Rec", 
			"NJobNum", 
			"DateShipped", 
			"BackOrders", 
			"BackOrdersShipped", 
			"propshipdate", 
			"shipcomments", 
			"shipdetails", 
			"DealerRoute", 
			"OrgJobNum", 
			"UpdatedBy", 
			"LastUpdated");
		$pagination = $this->get_pagination(20); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist2015.JobNum LIKE ? OR 
				joblist2015.Artisan LIKE ? OR 
				joblist2015.Dealer LIKE ? OR 
				joblist2015.CustomerNum LIKE ? OR 
				joblist2015.TagName LIKE ? OR 
				joblist2015.OrderEntry LIKE ? OR 
				joblist2015.SalesRep LIKE ? OR 
				joblist2015.RecdOrder LIKE ? OR 
				joblist2015.StdLeadTime LIKE ? OR 
				joblist2015.ReqDate LIKE ? OR 
				joblist2015.Value LIKE ? OR 
				joblist2015.SentToOE LIKE ? OR 
				joblist2015.SentToDealer LIKE ? OR 
				joblist2015.Confirmed LIKE ? OR 
				joblist2015.SentToPlant LIKE ? OR 
				joblist2015.Inv LIKE ? OR 
				joblist2015.Comments LIKE ? OR 
				joblist2015.TimeStamp LIKE ? OR 
				joblist2015.RSO LIKE ? OR 
				joblist2015.Uppers LIKE ? OR 
				joblist2015.Talls LIKE ? OR 
				joblist2015.Bases LIKE ? OR 
				joblist2015.Vanities LIKE ? OR 
				joblist2015.Accessories LIKE ? OR 
				joblist2015.Wood LIKE ? OR 
				joblist2015.Colour LIKE ? OR 
				joblist2015.DoorVendor LIKE ? OR 
				joblist2015.DoorETA LIKE ? OR 
				joblist2015.OtherETA LIKE ? OR 
				joblist2015.Priority LIKE ? OR 
				joblist2015.Creator LIKE ? OR 
				joblist2015.DoorStyle LIKE ? OR 
				joblist2015.Conf_Rec LIKE ? OR 
				joblist2015.NJobNum LIKE ? OR 
				joblist2015.DateShipped LIKE ? OR 
				joblist2015.BackOrders LIKE ? OR 
				joblist2015.BackOrdersShipped LIKE ? OR 
				joblist2015.propshipdate LIKE ? OR 
				joblist2015.shipcomments LIKE ? OR 
				joblist2015.shipdetails LIKE ? OR 
				joblist2015.DealerRoute LIKE ? OR 
				joblist2015.OrgJobNum LIKE ? OR 
				joblist2015.UpdatedBy LIKE ? OR 
				joblist2015.LastUpdated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist2015/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("joblist2015.JobNum", ORDER_TYPE);
		}
		$db->where("INV < '2021-05-04' AND `SentToPlant` > '2021-05-05'");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Joblist2015";
		$view_name = (is_ajax() ? "joblist2015/ajax-list_4_acc.php" : "joblist2015/list_4_acc.php");
		$this->render_view($view_name, $data);
	}
}
