<?php 
/**
 * Joblist_view Page Controller
 * @category  Controller
 */
class Joblist_viewController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "joblist_view";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("NJobNum", 
			"Accounting_Received", 
			"JobNo", 
			"Dealer", 
			"TagName", 
			"OrderEntry", 
			"RecdOrder", 
			"Value", 
			"SentToPlant", 
			"Inv", 
			"Comments", 
			"Paid", 
			"Invoiced", 
			"Note");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				joblist_view.NJobNum LIKE ? OR 
				joblist_view.Accounting_Received LIKE ? OR 
				joblist_view.JobNo LIKE ? OR 
				joblist_view.Dealer LIKE ? OR 
				joblist_view.TagName LIKE ? OR 
				joblist_view.OrderEntry LIKE ? OR 
				joblist_view.RecdOrder LIKE ? OR 
				joblist_view.Value LIKE ? OR 
				joblist_view.SentToPlant LIKE ? OR 
				joblist_view.Inv LIKE ? OR 
				joblist_view.Comments LIKE ? OR 
				joblist_view.JobNum LIKE ? OR 
				joblist_view.Created_By LIKE ? OR 
				joblist_view.Time_Created LIKE ? OR 
				joblist_view.Paid LIKE ? OR 
				joblist_view.Time_Paid LIKE ? OR 
				joblist_view.Invoiced LIKE ? OR 
				joblist_view.Note LIKE ? OR 
				joblist_view.Updated_By LIKE ? OR 
				joblist_view.Updated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "joblist_view/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("joblist_view.NJobNum", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Joblist View";
		$view_name = (is_ajax() ? "joblist_view/ajax-list.php" : "joblist_view/list.php");
		$this->render_view($view_name, $data);
	}
}
