<?php 
/**
 * Joblist Page Controller
 * @category  Controller
 */
class JoblistController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "joblist";
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Artisan", 
			"Dealer", 
			"CustomerNum", 
			"TagName", 
			"OrderEntry", 
			"SalesRep", 
			"RecdOrder", 
			"StdLeadTime", 
			"ReqDate", 
			"Value", 
			"SentToOE", 
			"SentToDealer", 
			"Confirmed", 
			"SentToPlant", 
			"Inv", 
			"Comments", 
			"TimeStamp", 
			"RSO", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Wood", 
			"Colour", 
			"DoorVendor", 
			"DoorETA", 
			"OtherETA", 
			"Priority", 
			"Creator", 
			"DoorStyle", 
			"Conf_Rec", 
			"NJobNum", 
			"DateShipped", 
			"BackOrders", 
			"BackOrdersShipped", 
			"propshipdate", 
			"shipcomments", 
			"shipdetails", 
			"DealerRoute", 
			"OrgJobNum", 
			"UpdatedBy", 
			"LastUpdated");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("joblist.JobNum", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Joblist";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("joblist/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("JobNum","Artisan","Dealer","CustomerNum","TagName","OrderEntry","SalesRep","RecdOrder","StdLeadTime","ReqDate","Value","SentToOE","SentToDealer","Confirmed","SentToPlant","Inv","Comments","RSO","Uppers","Talls","Bases","Vanities","Accessories","Wood","Colour","DoorVendor","DoorETA","OtherETA","Priority","Creator","DoorStyle","Conf_Rec","NJobNum","DateShipped","BackOrders","BackOrdersShipped","propshipdate","shipcomments","shipdetails","DealerRoute","OrgJobNum","UpdatedBy","LastUpdated");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'JobNum' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'Artisan' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'CustomerNum' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'OrderEntry' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'RecdOrder' => 'sanitize_string',
				'StdLeadTime' => 'sanitize_string',
				'ReqDate' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'SentToOE' => 'sanitize_string',
				'SentToDealer' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'SentToPlant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorETA' => 'sanitize_string',
				'OtherETA' => 'sanitize_string',
				'Priority' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'DateShipped' => 'sanitize_string',
				'BackOrders' => 'sanitize_string',
				'BackOrdersShipped' => 'sanitize_string',
				'propshipdate' => 'sanitize_string',
				'shipcomments' => 'sanitize_string',
				'shipdetails' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("joblist");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Joblist";
		$this->render_view("joblist/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("JobNum","Artisan","Dealer","CustomerNum","TagName","OrderEntry","SalesRep","RecdOrder","StdLeadTime","ReqDate","Value","SentToOE","SentToDealer","Confirmed","SentToPlant","Inv","Comments","RSO","Uppers","Talls","Bases","Vanities","Accessories","Wood","Colour","DoorVendor","DoorETA","OtherETA","Priority","Creator","DoorStyle","Conf_Rec","NJobNum","DateShipped","BackOrders","BackOrdersShipped","propshipdate","shipcomments","shipdetails","DealerRoute","OrgJobNum","UpdatedBy","LastUpdated");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'JobNum' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'Artisan' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'CustomerNum' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'OrderEntry' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'RecdOrder' => 'sanitize_string',
				'StdLeadTime' => 'sanitize_string',
				'ReqDate' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'SentToOE' => 'sanitize_string',
				'SentToDealer' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'SentToPlant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorETA' => 'sanitize_string',
				'OtherETA' => 'sanitize_string',
				'Priority' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'DateShipped' => 'sanitize_string',
				'BackOrders' => 'sanitize_string',
				'BackOrdersShipped' => 'sanitize_string',
				'propshipdate' => 'sanitize_string',
				'shipcomments' => 'sanitize_string',
				'shipdetails' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("joblist.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("joblist");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("joblist");
					}
				}
			}
		}
		$db->where("joblist.JobNum", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Joblist";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("joblist/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("JobNum","Artisan","Dealer","CustomerNum","TagName","OrderEntry","SalesRep","RecdOrder","StdLeadTime","ReqDate","Value","SentToOE","SentToDealer","Confirmed","SentToPlant","Inv","Comments","RSO","Uppers","Talls","Bases","Vanities","Accessories","Wood","Colour","DoorVendor","DoorETA","OtherETA","Priority","Creator","DoorStyle","Conf_Rec","NJobNum","DateShipped","BackOrders","BackOrdersShipped","propshipdate","shipcomments","shipdetails","DealerRoute","OrgJobNum","UpdatedBy","LastUpdated");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'JobNum' => 'numeric',
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'Artisan' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'CustomerNum' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'OrderEntry' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'RecdOrder' => 'sanitize_string',
				'StdLeadTime' => 'sanitize_string',
				'ReqDate' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'SentToOE' => 'sanitize_string',
				'SentToDealer' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'SentToPlant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'DoorVendor' => 'sanitize_string',
				'DoorETA' => 'sanitize_string',
				'OtherETA' => 'sanitize_string',
				'Priority' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'DoorStyle' => 'sanitize_string',
				'Conf_Rec' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'DateShipped' => 'sanitize_string',
				'BackOrders' => 'sanitize_string',
				'BackOrdersShipped' => 'sanitize_string',
				'propshipdate' => 'sanitize_string',
				'shipcomments' => 'sanitize_string',
				'shipdetails' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("joblist.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
