<?php 
/**
 * Jlv2_aa_0_oc_users Page Controller
 * @category  Controller
 */
class Jlv2_aa_0_oc_usersController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jlv2_aa_0_oc_users";
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("uid","displayname","password","uid_lower","email","type","jl_type","ql_type","sl_type","rl_type","initials","account_status","lastcode");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'email' => 'valid_email',
			);
			$this->sanitize_array = array(
				'uid' => 'sanitize_string',
				'displayname' => 'sanitize_string',
				'uid_lower' => 'sanitize_string',
				'email' => 'sanitize_string',
				'type' => 'sanitize_string',
				'jl_type' => 'sanitize_string',
				'ql_type' => 'sanitize_string',
				'sl_type' => 'sanitize_string',
				'rl_type' => 'sanitize_string',
				'initials' => 'sanitize_string',
				'account_status' => 'sanitize_string',
				'lastcode' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_aa_0_oc_users.uid", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
