<?php 
/**
 * Job Page Controller
 * @category  Controller
 */
class JobController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "job";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Job_Number_Prefix", 
			"Job_Number", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Received_Order", 
			"Original_Job_Number", 
			"Description", 
			"OE", 
			"Sales_Rep", 
			"Requested_Date", 
			"Value", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"To_Plant", 
			"Confirmed_Ship_Date", 
			"Invoiced", 
			"TimeStamp", 
			"Job_Type", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Material", 
			"Door_Vendor", 
			"Door_ETA", 
			"Date_Shipped", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Lead_Time", 
			"Status", 
			"Creator", 
			"Dealer_Route", 
			"Updated_By", 
			"Last_Updated", 
			"Custom_Cabinets");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.To_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Status LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ? OR 
				job.Custom_Cabinets LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Jobs List For Order Entry";
		$view_name = (is_ajax() ? "job/ajax-list.php" : "job/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("job.Job_Number_Prefix", 
			"job.Job_Number", 
			"job.Dealer", 
			"job.Customer_PO", 
			"job.Tag_Name", 
			"job.Received_Order", 
			"job.Original_Job_Number", 
			"job.Description", 
			"job.OE", 
			"job.Sales_Rep", 
			"job.Requested_Date", 
			"job.Value", 
			"job.Sent_To_OE", 
			"job.Sent_For_Confirmation", 
			"job.Confirmation_Received", 
			"job.Confirmed", 
			"job.Sent_To_Plant", 
			"job.To_Plant", 
			"job.Confirmed_Ship_Date", 
			"job.Invoiced", 
			"job.TimeStamp", 
			"job.Job_Type", 
			"job.Uppers", 
			"job.Talls", 
			"job.Bases", 
			"job.Vanities", 
			"job.Accessories", 
			"job.Door_Style", 
			"job.Wood", 
			"job.Colour", 
			"job.Material", 
			"job.Door_Vendor", 
			"job.Door_ETA", 
			"job.Date_Shipped", 
			"job.Back_Orders", 
			"job.Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date", 
			"job.Lead_Time", 
			"job.Status", 
			"job.Creator", 
			"job.Dealer_Route", 
			"job.Updated_By", 
			"job.Last_Updated", 
			"job.Custom_Cabinets", 
			"production.Full_Job_Number AS production_Full_Job_Number", 
			"production.Job_Number_Prefix AS production_Job_Number_Prefix", 
			"production.Job_Number AS production_Job_Number", 
			"production.Job_Reviewed AS production_Job_Reviewed", 
			"production.RGA_Approval_Received AS production_RGA_Approval_Received", 
			"production.Material_Ordered AS production_Material_Ordered", 
			"production.Material_ETA AS production_Material_ETA", 
			"production.Material_Received AS production_Material_Received", 
			"production.Doors_Ordered AS production_Doors_Ordered", 
			"production.Door_ETA AS production_Door_ETA", 
			"production.Accessories_Ordered AS production_Accessories_Ordered", 
			"production.Paint_Ordered AS production_Paint_Ordered", 
			"production.Finishing_Required AS production_Finishing_Required", 
			"production.CUSTOM_FINISHED_PARTS AS production_CUSTOM_FINISHED_PARTS", 
			"production.CUSTOM_UNFINISHED_PARTS AS production_CUSTOM_UNFINISHED_PARTS", 
			"production.Job_Programmed AS production_Job_Programmed", 
			"production.Doors_Received AS production_Doors_Received", 
			"production.Doors_Drilled AS production_Doors_Drilled", 
			"production.Accessories_Received AS production_Accessories_Received", 
			"production.Finished_Parts_CNC AS production_Finished_Parts_CNC", 
			"production.Finished_Parts_Banded_Doweled AS production_Finished_Parts_Banded_Doweled", 
			"production.Custom_Parts_Completed AS production_Custom_Parts_Completed", 
			"production.Parts_ready_for_Finishing AS production_Parts_ready_for_Finishing", 
			"production.Finished_Parts_Complete AS production_Finished_Parts_Complete", 
			"production.Unfinished_Parts_CNC AS production_Unfinished_Parts_CNC", 
			"production.Unfinished_Parts_Complete AS production_Unfinished_Parts_Complete", 
			"production.Cabinets_Assembled AS production_Cabinets_Assembled", 
			"production.Cabinets_Wrapped AS production_Cabinets_Wrapped", 
			"production.Packages_Wrapped AS production_Packages_Wrapped", 
			"production.Job_Ready_to_Ship AS production_Job_Ready_to_Ship", 
			"production.Drawer_Type AS production_Drawer_Type", 
			"production.Finished_End_Sq_Ft AS production_Finished_End_Sq_Ft", 
			"production.Door_Sq_Ft AS production_Door_Sq_Ft", 
			"production.MDF_SHEET_QUANTITY AS production_MDF_SHEET_QUANTITY", 
			"production.MEL_SHEET_QUANTITY AS production_MEL_SHEET_QUANTITY", 
			"production.FIN_SHEET_QUANTITY AS production_FIN_SHEET_QUANTITY", 
			"production.Job_Reviewed_TS AS production_Job_Reviewed_TS", 
			"production.RGA_Approval_Received_TS AS production_RGA_Approval_Received_TS", 
			"production.Material_Ordered_TS AS production_Material_Ordered_TS", 
			"production.Material_Received_TS AS production_Material_Received_TS", 
			"production.Doors_Ordered_TS AS production_Doors_Ordered_TS", 
			"production.Accessories_Ordered_TS AS production_Accessories_Ordered_TS", 
			"production.Paint_Ordered_TS AS production_Paint_Ordered_TS", 
			"production.Finishing_Required_TS AS production_Finishing_Required_TS", 
			"production.CUSTOM_FINISHED_PARTS_TS AS production_CUSTOM_FINISHED_PARTS_TS", 
			"production.CUSTOM_UNFINISHED_PARTS_TS AS production_CUSTOM_UNFINISHED_PARTS_TS", 
			"production.Job_Programmed_TS AS production_Job_Programmed_TS", 
			"production.Doors_Received_TS AS production_Doors_Received_TS", 
			"production.Doors_Drilled_TS AS production_Doors_Drilled_TS", 
			"production.Accessories_Received_TS AS production_Accessories_Received_TS", 
			"production.Finished_Parts_CNC_TS AS production_Finished_Parts_CNC_TS", 
			"production.Finished_Parts_Banded_Doweled_TS AS production_Finished_Parts_Banded_Doweled_TS", 
			"production.Custom_Parts_Completed_TS AS production_Custom_Parts_Completed_TS", 
			"production.Parts_ready_for_Finishing_TS AS production_Parts_ready_for_Finishing_TS", 
			"production.Finished_Parts_Complete_TS AS production_Finished_Parts_Complete_TS", 
			"production.Unfinished_Parts_CNC_TS AS production_Unfinished_Parts_CNC_TS", 
			"production.Unfinished_Parts_Complete_TS AS production_Unfinished_Parts_Complete_TS", 
			"production.Cabinets_Assembled_TS AS production_Cabinets_Assembled_TS", 
			"production.Cabinets_Wrapped_TS AS production_Cabinets_Wrapped_TS", 
			"production.Packages_Wrapped_TS AS production_Packages_Wrapped_TS", 
			"production.Job_Ready_to_Ship_TS AS production_Job_Ready_to_Ship_TS", 
			"production.pk_Production AS production_pk_Production", 
			"accounting.Created_By AS accounting_Created_By", 
			"accounting.Paid AS accounting_Paid", 
			"accounting.Invoiced AS accounting_Invoiced", 
			"accounting.Note AS accounting_Note", 
			"accounting.Updated_By AS accounting_Updated_By", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"accounting.Job_Number AS accounting_Job_Number", 
			"accounting.Created_TS AS accounting_Created_TS", 
			"accounting.Paid_TS AS accounting_Paid_TS", 
			"accounting.Updated_TS AS accounting_Updated_TS", 
			"accounting.Accounting_Received_TS AS accounting_Accounting_Received_TS", 
			"accounting.Invoiced_TS AS accounting_Invoiced_TS", 
			"accounting.Deposit_Required AS accounting_Deposit_Required", 
			"accounting.Deposit_Paid_TS AS accounting_Deposit_Paid_TS", 
			"accounting.Deposit_Paid AS accounting_Deposit_Paid");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("job.Job_Number", $rec_id);; //select record based on primary key
		}
		$db->join("accounting", "job.Job_Number = accounting.Job_Number", "LEFT ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Job";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("job/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Number_Prefix","Job_Number","Job_Type","Dealer","Customer_PO","Tag_Name","Received_Order","Original_Job_Number","Description","OE","Requested_Date","Value","Sent_To_OE","Door_Style","Wood","Colour","Door_Vendor","Status","Creator");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Value' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Description' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Creator' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			//Check if Duplicate Record Already Exit In The Database
			$db->where("Job_Number", $modeldata['Job_Number']);
			if($db->has($tablename)){
				$this->view->page_error[] = $modeldata['Job_Number']." Already exist!";
			} 
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("job");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Job";
		$this->render_view("job/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Job_Number_Prefix","Job_Number","Job_Type","Dealer","Customer_PO","Tag_Name","Received_Order","Original_Job_Number","Description","OE","Requested_Date","Value","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","To_Plant","Confirmed_Ship_Date","Invoiced","Uppers","Talls","Bases","Vanities","Accessories","Custom_Cabinets","Door_Style","Wood","Colour","Door_Vendor","Door_ETA","Date_Shipped","Status","Creator");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Description' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'To_Plant' => 'sanitize_string',
				'Confirmed_Ship_Date' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Custom_Cabinets' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Creator' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			//Check if Duplicate Record Already Exit In The Database
			if(isset($modeldata['Job_Number'])){
				$db->where("Job_Number", $modeldata['Job_Number'])->where("Job_Number", $rec_id, "!=");
				if($db->has($tablename)){
					$this->view->page_error[] = $modeldata['Job_Number']." Already exist!";
				}
			} 
			if($this->validated()){
				$db->where("job.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("job");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("job");
					}
				}
			}
		}
		$db->where("job.Job_Number", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Job";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("job/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Job_Number_Prefix","Job_Number","Job_Type","Dealer","Customer_PO","Tag_Name","Received_Order","Original_Job_Number","Description","OE","Requested_Date","Value","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","To_Plant","Confirmed_Ship_Date","Invoiced","Uppers","Talls","Bases","Vanities","Accessories","Custom_Cabinets","Door_Style","Wood","Colour","Door_Vendor","Door_ETA","Date_Shipped","Status","Creator");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Value' => 'numeric',
				'Uppers' => 'numeric',
				'Talls' => 'numeric',
				'Bases' => 'numeric',
				'Vanities' => 'numeric',
				'Accessories' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Job_Type' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Original_Job_Number' => 'sanitize_string',
				'Description' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'To_Plant' => 'sanitize_string',
				'Confirmed_Ship_Date' => 'sanitize_string',
				'Invoiced' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Custom_Cabinets' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Status' => 'sanitize_string',
				'Creator' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			//Check if Duplicate Record Already Exit In The Database
			if(isset($modeldata['Job_Number'])){
				$db->where("Job_Number", $modeldata['Job_Number'])->where("Job_Number", $rec_id, "!=");
				if($db->has($tablename)){
					$this->view->page_error[] = $modeldata['Job_Number']." Already exist!";
				}
			} 
			if($this->validated()){
				$db->where("job.Job_Number", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function jobs($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("job.Job_Type", 
			"Concat(`job`.`Job_Number_Prefix`,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `job`.`Job_Number`)))) AS DJobNum", 
			"job.Job_Number_Prefix", 
			"job.Job_Number", 
			"job.Dealer", 
			"job.Customer_PO", 
			"job.Tag_Name", 
			"job.Received_Order", 
			"job.Original_Job_Number", 
			"job.Description", 
			"job.Value", 
			"job.Sent_To_Plant", 
			"job.To_Plant", 
			"job.Confirmed_Ship_Date", 
			"job.Uppers", 
			"job.Talls", 
			"job.Bases", 
			"job.Vanities", 
			"job.Accessories", 
			"job.Wood", 
			"job.Colour", 
			"job.Material", 
			"job.Custom_Cabinets", 
			"job.Door_Style", 
			"job.Door_Vendor", 
			"job.Door_ETA", 
			"job.Status", 
			"production.Job_Reviewed AS production_Job_Reviewed", 
			"production.RGA_Approval_Received AS production_RGA_Approval_Received", 
			"production.Material_Ordered AS production_Material_Ordered", 
			"production.Material_ETA AS production_Material_ETA", 
			"production.Material_Received AS production_Material_Received", 
			"production.Doors_Ordered AS production_Doors_Ordered", 
			"production.Door_ETA AS production_Door_ETA", 
			"production.Accessories_Ordered AS production_Accessories_Ordered", 
			"production.Paint_Ordered AS production_Paint_Ordered", 
			"production.Finishing_Required AS production_Finishing_Required", 
			"production.CUSTOM_FINISHED_PARTS AS production_CUSTOM_FINISHED_PARTS", 
			"production.CUSTOM_UNFINISHED_PARTS AS production_CUSTOM_UNFINISHED_PARTS", 
			"production.Job_Programmed AS production_Job_Programmed", 
			"production.Doors_Received AS production_Doors_Received", 
			"production.Doors_Drilled AS production_Doors_Drilled", 
			"production.Accessories_Received AS production_Accessories_Received", 
			"production.Finished_Parts_CNC AS production_Finished_Parts_CNC", 
			"production.Finished_Parts_Banded_Doweled AS production_Finished_Parts_Banded_Doweled", 
			"production.Custom_Parts_Completed AS production_Custom_Parts_Completed", 
			"production.Parts_ready_for_Finishing AS production_Parts_ready_for_Finishing", 
			"production.Finished_Parts_Complete AS production_Finished_Parts_Complete", 
			"production.Unfinished_Parts_CNC AS production_Unfinished_Parts_CNC", 
			"production.Unfinished_Parts_Complete AS production_Unfinished_Parts_Complete", 
			"production.Cabinets_Assembled AS production_Cabinets_Assembled", 
			"production.Cabinets_Wrapped AS production_Cabinets_Wrapped", 
			"production.Packages_Wrapped AS production_Packages_Wrapped", 
			"production.Job_Ready_to_Ship AS production_Job_Ready_to_Ship", 
			"production.Drawer_Type AS production_Drawer_Type", 
			"production.Finished_End_Sq_Ft AS production_Finished_End_Sq_Ft", 
			"production.Door_Sq_Ft AS production_Door_Sq_Ft", 
			"production.MDF_SHEET_QUANTITY AS production_MDF_SHEET_QUANTITY", 
			"production.MEL_SHEET_QUANTITY AS production_MEL_SHEET_QUANTITY", 
			"production.FIN_SHEET_QUANTITY AS production_FIN_SHEET_QUANTITY", 
			"production.pk_Production AS production_pk_Production");
		$pagination = $this->get_pagination(20); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				job.Job_Type LIKE ? OR 
				job.DJobNum LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.To_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Custom_Cabinets LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Status LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ? OR 
				production.Full_Job_Number LIKE ? OR 
				production.Job_Number_Prefix LIKE ? OR 
				production.Job_Number LIKE ? OR 
				production.Job_Reviewed LIKE ? OR 
				production.RGA_Approval_Received LIKE ? OR 
				production.Material_Ordered LIKE ? OR 
				production.Material_ETA LIKE ? OR 
				production.Material_Received LIKE ? OR 
				production.Doors_Ordered LIKE ? OR 
				production.Door_ETA LIKE ? OR 
				production.Accessories_Ordered LIKE ? OR 
				production.Paint_Ordered LIKE ? OR 
				production.Finishing_Required LIKE ? OR 
				production.CUSTOM_FINISHED_PARTS LIKE ? OR 
				production.CUSTOM_UNFINISHED_PARTS LIKE ? OR 
				production.Job_Programmed LIKE ? OR 
				production.Doors_Received LIKE ? OR 
				production.Doors_Drilled LIKE ? OR 
				production.Accessories_Received LIKE ? OR 
				production.Finished_Parts_CNC LIKE ? OR 
				production.Finished_Parts_Banded_Doweled LIKE ? OR 
				production.Custom_Parts_Completed LIKE ? OR 
				production.Parts_ready_for_Finishing LIKE ? OR 
				production.Finished_Parts_Complete LIKE ? OR 
				production.Unfinished_Parts_CNC LIKE ? OR 
				production.Unfinished_Parts_Complete LIKE ? OR 
				production.Cabinets_Assembled LIKE ? OR 
				production.Cabinets_Wrapped LIKE ? OR 
				production.Packages_Wrapped LIKE ? OR 
				production.Job_Ready_to_Ship LIKE ? OR 
				production.Drawer_Type LIKE ? OR 
				production.Finished_End_Sq_Ft LIKE ? OR 
				production.Door_Sq_Ft LIKE ? OR 
				production.MDF_SHEET_QUANTITY LIKE ? OR 
				production.MEL_SHEET_QUANTITY LIKE ? OR 
				production.FIN_SHEET_QUANTITY LIKE ? OR 
				production.Job_Reviewed_TS LIKE ? OR 
				production.RGA_Approval_Received_TS LIKE ? OR 
				production.Material_Ordered_TS LIKE ? OR 
				production.Material_Received_TS LIKE ? OR 
				production.Doors_Ordered_TS LIKE ? OR 
				production.Accessories_Ordered_TS LIKE ? OR 
				production.Paint_Ordered_TS LIKE ? OR 
				production.Finishing_Required_TS LIKE ? OR 
				production.CUSTOM_FINISHED_PARTS_TS LIKE ? OR 
				production.CUSTOM_UNFINISHED_PARTS_TS LIKE ? OR 
				production.Job_Programmed_TS LIKE ? OR 
				production.Doors_Received_TS LIKE ? OR 
				production.Doors_Drilled_TS LIKE ? OR 
				production.Accessories_Received_TS LIKE ? OR 
				production.Finished_Parts_CNC_TS LIKE ? OR 
				production.Finished_Parts_Banded_Doweled_TS LIKE ? OR 
				production.Custom_Parts_Completed_TS LIKE ? OR 
				production.Parts_ready_for_Finishing_TS LIKE ? OR 
				production.Finished_Parts_Complete_TS LIKE ? OR 
				production.Unfinished_Parts_CNC_TS LIKE ? OR 
				production.Unfinished_Parts_Complete_TS LIKE ? OR 
				production.Cabinets_Assembled_TS LIKE ? OR 
				production.Cabinets_Wrapped_TS LIKE ? OR 
				production.Packages_Wrapped_TS LIKE ? OR 
				production.Job_Ready_to_Ship_TS LIKE ? OR 
				production.pk_Production LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		$db->join("production", "job.Job_Number = production.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Job";
		$view_name = (is_ajax() ? "job/ajax-jobs.php" : "job/jobs.php");
		$this->render_view($view_name, $data);
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function acc_list($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(`job`.`Job_Number_Prefix`,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `job`.`Job_Number`)))) AS DJobNum", 
			"job.Job_Number", 
			"job.Dealer", 
			"job.Customer_PO", 
			"job.Tag_Name", 
			"job.Received_Order", 
			"job.Original_Job_Number", 
			"job.Description", 
			"job.OE", 
			"job.Sales_Rep", 
			"job.Requested_Date", 
			"job.Value", 
			"job.Sent_To_OE", 
			"job.Sent_For_Confirmation", 
			"job.Confirmation_Received", 
			"job.Confirmed", 
			"job.Sent_To_Plant", 
			"job.To_Plant", 
			"job.Confirmed_Ship_Date", 
			"job.Invoiced", 
			"job.TimeStamp", 
			"job.Job_Type", 
			"job.Uppers", 
			"job.Talls", 
			"job.Bases", 
			"job.Vanities", 
			"job.Accessories", 
			"job.Door_Style", 
			"job.Wood", 
			"job.Colour", 
			"job.Material", 
			"job.Door_Vendor", 
			"job.Door_ETA", 
			"job.Date_Shipped", 
			"job.Back_Orders", 
			"job.Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date", 
			"job.Lead_Time", 
			"job.Status", 
			"job.Creator", 
			"job.Dealer_Route", 
			"job.Updated_By", 
			"job.Last_Updated", 
			"job.Custom_Cabinets", 
			"accounting.Created_By AS accounting_Created_By", 
			"accounting.Paid AS accounting_Paid", 
			"accounting.Note AS accounting_Note", 
			"accounting.Updated_By AS accounting_Updated_By", 
			"accounting.Accounting_Received AS accounting_Accounting_Received", 
			"accounting.Job_Number AS accounting_Job_Number");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				job.DJobNum LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.To_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Status LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ? OR 
				job.Custom_Cabinets LIKE ? OR 
				accounting.Created_By LIKE ? OR 
				accounting.Paid LIKE ? OR 
				accounting.Invoiced LIKE ? OR 
				accounting.Note LIKE ? OR 
				accounting.Updated_By LIKE ? OR 
				accounting.Accounting_Received LIKE ? OR 
				accounting.Job_Number LIKE ? OR 
				accounting.Created_TS LIKE ? OR 
				accounting.Paid_TS LIKE ? OR 
				accounting.Updated_TS LIKE ? OR 
				accounting.Accounting_Received_TS LIKE ? OR 
				accounting.Invoiced_TS LIKE ? OR 
				accounting.Deposit_Required LIKE ? OR 
				accounting.Deposit_Paid_TS LIKE ? OR 
				accounting.Deposit_Paid LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "job/search.php";
		}
		$db->join("accounting", "job.Job_Number = accounting.Job_Number", "LEFT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("job.Job_Number", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Job";
		$view_name = (is_ajax() ? "job/ajax-acc_list.php" : "job/acc_list.php");
		$this->render_view($view_name, $data);
	}
}
