<?php 
/**
 * Production Page Controller
 * @category  Controller
 */
class ProductionController extends BaseController{
	function __construct(){
		parent::__construct();
		$this->tablename = "production";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Job_Number", 
			"Job_Reviewed", 
			"RGA_Approval_Received", 
			"Material_Ordered", 
			"Material_ETA", 
			"Material_Received", 
			"Doors_Ordered", 
			"Door_ETA", 
			"Accessories_Ordered", 
			"Paint_Ordered", 
			"Finishing_Required", 
			"CUSTOM_FINISHED_PARTS", 
			"CUSTOM_UNFINISHED_PARTS", 
			"Job_Programmed", 
			"Doors_Received", 
			"Doors_Drilled", 
			"Accessories_Received", 
			"Finished_Parts_CNC", 
			"Finished_Parts_Banded_Doweled", 
			"Custom_Parts_Completed", 
			"Parts_ready_for_Finishing", 
			"Finished_Parts_Complete", 
			"Unfinished_Parts_CNC", 
			"Unfinished_Parts_Complete", 
			"Cabinets_Assembled", 
			"Cabinets_Wrapped", 
			"Packages_Wrapped", 
			"Job_Ready_to_Ship", 
			"Drawer_Type", 
			"Finished_End_Sq_Ft", 
			"Door_Sq_Ft", 
			"MDF_SHEET_QUANTITY", 
			"MEL_SHEET_QUANTITY", 
			"FIN_SHEET_QUANTITY", 
			"CUSTOM_FINISHED_PARTS_TS", 
			"CUSTOM_UNFINISHED_PARTS_TS", 
			"Doors_Drilled_TS", 
			"Accessories_Received_TS", 
			"Finished_Parts_CNC_TS", 
			"Finished_Parts_Banded_Doweled_TS", 
			"Custom_Parts_Completed_TS", 
			"Parts_ready_for_Finishing_TS", 
			"Finished_Parts_Complete_TS", 
			"Unfinished_Parts_CNC_TS", 
			"Unfinished_Parts_Complete_TS", 
			"Cabinets_Assembled_TS", 
			"Cabinets_Wrapped_TS", 
			"Packages_Wrapped_TS", 
			"Job_Ready_to_Ship_TS", 
			"pk_Production");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				production.Full_Job_Number LIKE ? OR 
				production.Job_Number_Prefix LIKE ? OR 
				production.Job_Number LIKE ? OR 
				production.Job_Reviewed LIKE ? OR 
				production.RGA_Approval_Received LIKE ? OR 
				production.Material_Ordered LIKE ? OR 
				production.Material_ETA LIKE ? OR 
				production.Material_Received LIKE ? OR 
				production.Doors_Ordered LIKE ? OR 
				production.Door_ETA LIKE ? OR 
				production.Accessories_Ordered LIKE ? OR 
				production.Paint_Ordered LIKE ? OR 
				production.Finishing_Required LIKE ? OR 
				production.CUSTOM_FINISHED_PARTS LIKE ? OR 
				production.CUSTOM_UNFINISHED_PARTS LIKE ? OR 
				production.Job_Programmed LIKE ? OR 
				production.Doors_Received LIKE ? OR 
				production.Doors_Drilled LIKE ? OR 
				production.Accessories_Received LIKE ? OR 
				production.Finished_Parts_CNC LIKE ? OR 
				production.Finished_Parts_Banded_Doweled LIKE ? OR 
				production.Custom_Parts_Completed LIKE ? OR 
				production.Parts_ready_for_Finishing LIKE ? OR 
				production.Finished_Parts_Complete LIKE ? OR 
				production.Unfinished_Parts_CNC LIKE ? OR 
				production.Unfinished_Parts_Complete LIKE ? OR 
				production.Cabinets_Assembled LIKE ? OR 
				production.Cabinets_Wrapped LIKE ? OR 
				production.Packages_Wrapped LIKE ? OR 
				production.Job_Ready_to_Ship LIKE ? OR 
				production.Drawer_Type LIKE ? OR 
				production.Finished_End_Sq_Ft LIKE ? OR 
				production.Door_Sq_Ft LIKE ? OR 
				production.MDF_SHEET_QUANTITY LIKE ? OR 
				production.MEL_SHEET_QUANTITY LIKE ? OR 
				production.FIN_SHEET_QUANTITY LIKE ? OR 
				production.Job_Reviewed_TS LIKE ? OR 
				production.RGA_Approval_Received_TS LIKE ? OR 
				production.Material_Ordered_TS LIKE ? OR 
				production.Material_Received_TS LIKE ? OR 
				production.Doors_Ordered_TS LIKE ? OR 
				production.Accessories_Ordered_TS LIKE ? OR 
				production.Paint_Ordered_TS LIKE ? OR 
				production.Finishing_Required_TS LIKE ? OR 
				production.CUSTOM_FINISHED_PARTS_TS LIKE ? OR 
				production.CUSTOM_UNFINISHED_PARTS_TS LIKE ? OR 
				production.Job_Programmed_TS LIKE ? OR 
				production.Doors_Received_TS LIKE ? OR 
				production.Doors_Drilled_TS LIKE ? OR 
				production.Accessories_Received_TS LIKE ? OR 
				production.Finished_Parts_CNC_TS LIKE ? OR 
				production.Finished_Parts_Banded_Doweled_TS LIKE ? OR 
				production.Custom_Parts_Completed_TS LIKE ? OR 
				production.Parts_ready_for_Finishing_TS LIKE ? OR 
				production.Finished_Parts_Complete_TS LIKE ? OR 
				production.Unfinished_Parts_CNC_TS LIKE ? OR 
				production.Unfinished_Parts_Complete_TS LIKE ? OR 
				production.Cabinets_Assembled_TS LIKE ? OR 
				production.Cabinets_Wrapped_TS LIKE ? OR 
				production.Packages_Wrapped_TS LIKE ? OR 
				production.Job_Ready_to_Ship_TS LIKE ? OR 
				production.pk_Production LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "production/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("production.pk_Production", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Production";
		$view_name = (is_ajax() ? "production/ajax-list.php" : "production/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("production.Full_Job_Number", 
			"production.Job_Number_Prefix", 
			"production.Job_Number", 
			"production.Job_Reviewed", 
			"production.RGA_Approval_Received", 
			"production.Material_Ordered", 
			"production.Material_ETA", 
			"production.Material_Received", 
			"production.Doors_Ordered", 
			"production.Door_ETA", 
			"production.Accessories_Ordered", 
			"production.Paint_Ordered", 
			"production.Finishing_Required", 
			"production.CUSTOM_FINISHED_PARTS", 
			"production.CUSTOM_UNFINISHED_PARTS", 
			"production.Job_Programmed", 
			"production.Doors_Received", 
			"production.Doors_Drilled", 
			"production.Accessories_Received", 
			"production.Finished_Parts_CNC", 
			"production.Finished_Parts_Banded_Doweled", 
			"production.Custom_Parts_Completed", 
			"production.Parts_ready_for_Finishing", 
			"production.Finished_Parts_Complete", 
			"production.Unfinished_Parts_CNC", 
			"production.Unfinished_Parts_Complete", 
			"production.Cabinets_Assembled", 
			"production.Cabinets_Wrapped", 
			"production.Packages_Wrapped", 
			"production.Job_Ready_to_Ship", 
			"production.Drawer_Type", 
			"production.Finished_End_Sq_Ft", 
			"production.Door_Sq_Ft", 
			"production.MDF_SHEET_QUANTITY", 
			"production.MEL_SHEET_QUANTITY", 
			"production.FIN_SHEET_QUANTITY", 
			"production.Job_Reviewed_TS", 
			"production.RGA_Approval_Received_TS", 
			"production.Material_Ordered_TS", 
			"production.Material_Received_TS", 
			"production.Doors_Ordered_TS", 
			"production.Accessories_Ordered_TS", 
			"production.Paint_Ordered_TS", 
			"production.Finishing_Required_TS", 
			"production.CUSTOM_FINISHED_PARTS_TS", 
			"production.CUSTOM_UNFINISHED_PARTS_TS", 
			"production.Job_Programmed_TS", 
			"production.Doors_Received_TS", 
			"production.Doors_Drilled_TS", 
			"production.Accessories_Received_TS", 
			"production.Finished_Parts_CNC_TS", 
			"production.Finished_Parts_Banded_Doweled_TS", 
			"production.Custom_Parts_Completed_TS", 
			"production.Parts_ready_for_Finishing_TS", 
			"production.Finished_Parts_Complete_TS", 
			"production.Unfinished_Parts_CNC_TS", 
			"production.Unfinished_Parts_Complete_TS", 
			"production.Cabinets_Assembled_TS", 
			"production.Cabinets_Wrapped_TS", 
			"production.Packages_Wrapped_TS", 
			"production.Job_Ready_to_Ship_TS", 
			"production.pk_Production", 
			"job.Job_Number_Prefix AS job_Job_Number_Prefix", 
			"job.Job_Number AS job_Job_Number", 
			"job.Dealer AS job_Dealer", 
			"job.Customer_PO AS job_Customer_PO", 
			"job.Tag_Name AS job_Tag_Name", 
			"job.Received_Order AS job_Received_Order", 
			"job.Original_Job_Number AS job_Original_Job_Number", 
			"job.Description AS job_Description", 
			"job.OE AS job_OE", 
			"job.Sales_Rep AS job_Sales_Rep", 
			"job.Requested_Date AS job_Requested_Date", 
			"job.Value AS job_Value", 
			"job.Sent_To_OE AS job_Sent_To_OE", 
			"job.Sent_For_Confirmation AS job_Sent_For_Confirmation", 
			"job.Confirmation_Received AS job_Confirmation_Received", 
			"job.Confirmed AS job_Confirmed", 
			"job.Sent_To_Plant AS job_Sent_To_Plant", 
			"job.To_Plant AS job_To_Plant", 
			"job.Confirmed_Ship_Date AS job_Confirmed_Ship_Date", 
			"job.Invoiced AS job_Invoiced", 
			"job.TimeStamp AS job_TimeStamp", 
			"job.Job_Type AS job_Job_Type", 
			"job.Uppers AS job_Uppers", 
			"job.Talls AS job_Talls", 
			"job.Bases AS job_Bases", 
			"job.Vanities AS job_Vanities", 
			"job.Accessories AS job_Accessories", 
			"job.Door_Style AS job_Door_Style", 
			"job.Wood AS job_Wood", 
			"job.Colour AS job_Colour", 
			"job.Material AS job_Material", 
			"job.Door_Vendor AS job_Door_Vendor", 
			"job.Door_ETA AS job_Door_ETA", 
			"job.Date_Shipped AS job_Date_Shipped", 
			"job.Back_Orders AS job_Back_Orders", 
			"job.Back_Orders_Shipped AS job_Back_Orders_Shipped", 
			"job.Proposed_Shipping_Date AS job_Proposed_Shipping_Date", 
			"job.Lead_Time AS job_Lead_Time", 
			"job.Status AS job_Status", 
			"job.Creator AS job_Creator", 
			"job.Dealer_Route AS job_Dealer_Route", 
			"job.Updated_By AS job_Updated_By", 
			"job.Last_Updated AS job_Last_Updated", 
			"job.Custom_Cabinets AS job_Custom_Cabinets");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("production.pk_Production", $rec_id);; //select record based on primary key
		}
		$db->join("job", "production.Job_Number = job.Job_Number", "RIGHT ");  
		$record = $db->getOne($tablename, $fields );
		if($record){
			$page_title = $this->view->page_title = "View  Production";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
		}
		return $this->render_view("production/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Reviewed","RGA_Approval_Received","Material_Ordered","Material_ETA","Material_Received","Doors_Ordered","Door_ETA","Accessories_Ordered","Paint_Ordered","Finishing_Required","CUSTOM_FINISHED_PARTS","CUSTOM_UNFINISHED_PARTS","Job_Programmed","Doors_Received","Doors_Drilled","Accessories_Received","Finished_Parts_CNC","Finished_Parts_Banded_Doweled","Custom_Parts_Completed","Parts_ready_for_Finishing","Finished_Parts_Complete","Unfinished_Parts_CNC","Unfinished_Parts_Complete","Cabinets_Assembled","Cabinets_Wrapped","Packages_Wrapped","Job_Ready_to_Ship","Drawer_Type","Finished_End_Sq_Ft","Door_Sq_Ft","MDF_SHEET_QUANTITY","MEL_SHEET_QUANTITY","FIN_SHEET_QUANTITY");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Finished_End_Sq_Ft' => 'numeric',
				'Door_Sq_Ft' => 'numeric',
				'MDF_SHEET_QUANTITY' => 'numeric',
				'MEL_SHEET_QUANTITY' => 'numeric',
				'FIN_SHEET_QUANTITY' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Reviewed' => 'sanitize_string',
				'RGA_Approval_Received' => 'sanitize_string',
				'Material_Ordered' => 'sanitize_string',
				'Material_ETA' => 'sanitize_string',
				'Material_Received' => 'sanitize_string',
				'Doors_Ordered' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Accessories_Ordered' => 'sanitize_string',
				'Paint_Ordered' => 'sanitize_string',
				'Finishing_Required' => 'sanitize_string',
				'CUSTOM_FINISHED_PARTS' => 'sanitize_string',
				'CUSTOM_UNFINISHED_PARTS' => 'sanitize_string',
				'Job_Programmed' => 'sanitize_string',
				'Doors_Received' => 'sanitize_string',
				'Doors_Drilled' => 'sanitize_string',
				'Accessories_Received' => 'sanitize_string',
				'Finished_Parts_CNC' => 'sanitize_string',
				'Finished_Parts_Banded_Doweled' => 'sanitize_string',
				'Custom_Parts_Completed' => 'sanitize_string',
				'Parts_ready_for_Finishing' => 'sanitize_string',
				'Finished_Parts_Complete' => 'sanitize_string',
				'Unfinished_Parts_CNC' => 'sanitize_string',
				'Unfinished_Parts_Complete' => 'sanitize_string',
				'Cabinets_Assembled' => 'sanitize_string',
				'Cabinets_Wrapped' => 'sanitize_string',
				'Packages_Wrapped' => 'sanitize_string',
				'Job_Ready_to_Ship' => 'sanitize_string',
				'Drawer_Type' => 'sanitize_string',
				'Finished_End_Sq_Ft' => 'sanitize_string',
				'Door_Sq_Ft' => 'sanitize_string',
				'MDF_SHEET_QUANTITY' => 'sanitize_string',
				'MEL_SHEET_QUANTITY' => 'sanitize_string',
				'FIN_SHEET_QUANTITY' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("production");
				}
				else{
					$this->set_page_error();
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Production";
		$this->render_view("production/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Job_Reviewed","RGA_Approval_Received","Material_Ordered","Material_ETA","Material_Received","Doors_Ordered","Door_ETA","Accessories_Ordered","Paint_Ordered","Finishing_Required","CUSTOM_FINISHED_PARTS","CUSTOM_UNFINISHED_PARTS","Job_Programmed","Doors_Received","Doors_Drilled","Accessories_Received","Finished_Parts_CNC","Finished_Parts_Banded_Doweled","Custom_Parts_Completed","Parts_ready_for_Finishing","Finished_Parts_Complete","Unfinished_Parts_CNC","Unfinished_Parts_Complete","Cabinets_Assembled","Cabinets_Wrapped","Packages_Wrapped","Job_Ready_to_Ship","Drawer_Type","Finished_End_Sq_Ft","Door_Sq_Ft","MDF_SHEET_QUANTITY","MEL_SHEET_QUANTITY","FIN_SHEET_QUANTITY","pk_Production");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Finished_End_Sq_Ft' => 'numeric',
				'Door_Sq_Ft' => 'numeric',
				'MDF_SHEET_QUANTITY' => 'numeric',
				'MEL_SHEET_QUANTITY' => 'numeric',
				'FIN_SHEET_QUANTITY' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Reviewed' => 'sanitize_string',
				'RGA_Approval_Received' => 'sanitize_string',
				'Material_Ordered' => 'sanitize_string',
				'Material_ETA' => 'sanitize_string',
				'Material_Received' => 'sanitize_string',
				'Doors_Ordered' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Accessories_Ordered' => 'sanitize_string',
				'Paint_Ordered' => 'sanitize_string',
				'Finishing_Required' => 'sanitize_string',
				'CUSTOM_FINISHED_PARTS' => 'sanitize_string',
				'CUSTOM_UNFINISHED_PARTS' => 'sanitize_string',
				'Job_Programmed' => 'sanitize_string',
				'Doors_Received' => 'sanitize_string',
				'Doors_Drilled' => 'sanitize_string',
				'Accessories_Received' => 'sanitize_string',
				'Finished_Parts_CNC' => 'sanitize_string',
				'Finished_Parts_Banded_Doweled' => 'sanitize_string',
				'Custom_Parts_Completed' => 'sanitize_string',
				'Parts_ready_for_Finishing' => 'sanitize_string',
				'Finished_Parts_Complete' => 'sanitize_string',
				'Unfinished_Parts_CNC' => 'sanitize_string',
				'Unfinished_Parts_Complete' => 'sanitize_string',
				'Cabinets_Assembled' => 'sanitize_string',
				'Cabinets_Wrapped' => 'sanitize_string',
				'Packages_Wrapped' => 'sanitize_string',
				'Job_Ready_to_Ship' => 'sanitize_string',
				'Drawer_Type' => 'sanitize_string',
				'Finished_End_Sq_Ft' => 'sanitize_string',
				'Door_Sq_Ft' => 'sanitize_string',
				'MDF_SHEET_QUANTITY' => 'sanitize_string',
				'MEL_SHEET_QUANTITY' => 'sanitize_string',
				'FIN_SHEET_QUANTITY' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("production.pk_Production", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("production");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						return	$this->redirect("production");
					}
				}
			}
		}
		$db->where("production.pk_Production", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Production";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("production/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Job_Reviewed","RGA_Approval_Received","Material_Ordered","Material_ETA","Material_Received","Doors_Ordered","Door_ETA","Accessories_Ordered","Paint_Ordered","Finishing_Required","CUSTOM_FINISHED_PARTS","CUSTOM_UNFINISHED_PARTS","Job_Programmed","Doors_Received","Doors_Drilled","Accessories_Received","Finished_Parts_CNC","Finished_Parts_Banded_Doweled","Custom_Parts_Completed","Parts_ready_for_Finishing","Finished_Parts_Complete","Unfinished_Parts_CNC","Unfinished_Parts_Complete","Cabinets_Assembled","Cabinets_Wrapped","Packages_Wrapped","Job_Ready_to_Ship","Drawer_Type","Finished_End_Sq_Ft","Door_Sq_Ft","MDF_SHEET_QUANTITY","MEL_SHEET_QUANTITY","FIN_SHEET_QUANTITY","pk_Production");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Finished_End_Sq_Ft' => 'numeric',
				'Door_Sq_Ft' => 'numeric',
				'MDF_SHEET_QUANTITY' => 'numeric',
				'MEL_SHEET_QUANTITY' => 'numeric',
				'FIN_SHEET_QUANTITY' => 'numeric',
			);
			$this->sanitize_array = array(
				'Job_Reviewed' => 'sanitize_string',
				'RGA_Approval_Received' => 'sanitize_string',
				'Material_Ordered' => 'sanitize_string',
				'Material_ETA' => 'sanitize_string',
				'Material_Received' => 'sanitize_string',
				'Doors_Ordered' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Accessories_Ordered' => 'sanitize_string',
				'Paint_Ordered' => 'sanitize_string',
				'Finishing_Required' => 'sanitize_string',
				'CUSTOM_FINISHED_PARTS' => 'sanitize_string',
				'CUSTOM_UNFINISHED_PARTS' => 'sanitize_string',
				'Job_Programmed' => 'sanitize_string',
				'Doors_Received' => 'sanitize_string',
				'Doors_Drilled' => 'sanitize_string',
				'Accessories_Received' => 'sanitize_string',
				'Finished_Parts_CNC' => 'sanitize_string',
				'Finished_Parts_Banded_Doweled' => 'sanitize_string',
				'Custom_Parts_Completed' => 'sanitize_string',
				'Parts_ready_for_Finishing' => 'sanitize_string',
				'Finished_Parts_Complete' => 'sanitize_string',
				'Unfinished_Parts_CNC' => 'sanitize_string',
				'Unfinished_Parts_Complete' => 'sanitize_string',
				'Cabinets_Assembled' => 'sanitize_string',
				'Cabinets_Wrapped' => 'sanitize_string',
				'Packages_Wrapped' => 'sanitize_string',
				'Job_Ready_to_Ship' => 'sanitize_string',
				'Drawer_Type' => 'sanitize_string',
				'Finished_End_Sq_Ft' => 'sanitize_string',
				'Door_Sq_Ft' => 'sanitize_string',
				'MDF_SHEET_QUANTITY' => 'sanitize_string',
				'MEL_SHEET_QUANTITY' => 'sanitize_string',
				'FIN_SHEET_QUANTITY' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("production.pk_Production", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("production.pk_Production", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
		}
		return	$this->redirect("production");
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function prod_checks($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(`job`.`Job_Number_Prefix`,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM `job`.`Job_Number`)))) AS DJobNum", 
			"production.Job_Number", 
			"production.Job_Reviewed", 
			"production.RGA_Approval_Received", 
			"production.Material_Ordered", 
			"production.Material_ETA", 
			"production.Material_Received", 
			"production.Doors_Ordered", 
			"production.Door_ETA", 
			"production.Accessories_Ordered", 
			"production.Paint_Ordered", 
			"production.Finishing_Required", 
			"production.CUSTOM_FINISHED_PARTS", 
			"production.CUSTOM_UNFINISHED_PARTS", 
			"production.Job_Programmed", 
			"production.Doors_Received", 
			"production.Doors_Drilled", 
			"production.Accessories_Received", 
			"production.Finished_Parts_CNC", 
			"production.Finished_Parts_Banded_Doweled", 
			"production.Custom_Parts_Completed", 
			"production.Parts_ready_for_Finishing", 
			"production.Finished_Parts_Complete", 
			"production.Unfinished_Parts_CNC", 
			"production.Unfinished_Parts_Complete", 
			"production.Cabinets_Assembled", 
			"production.Cabinets_Wrapped", 
			"production.Packages_Wrapped", 
			"production.Job_Ready_to_Ship", 
			"production.Finished_End_Sq_Ft", 
			"production.Door_Sq_Ft", 
			"production.MDF_SHEET_QUANTITY", 
			"production.MEL_SHEET_QUANTITY", 
			"production.FIN_SHEET_QUANTITY", 
			"production.pk_Production", 
			"job.Job_Number_Prefix AS job_Job_Number_Prefix", 
			"job.Job_Number AS job_Job_Number", 
			"job.Dealer AS job_Dealer", 
			"job.Tag_Name AS job_Tag_Name", 
			"job.Confirmation_Received AS job_Confirmation_Received", 
			"job.Sent_To_Plant AS job_Sent_To_Plant", 
			"job.To_Plant AS job_To_Plant", 
			"job.Confirmed_Ship_Date AS job_Confirmed_Ship_Date", 
			"job.Uppers AS job_Uppers", 
			"job.Talls AS job_Talls", 
			"job.Bases AS job_Bases", 
			"job.Vanities AS job_Vanities", 
			"job.Accessories AS job_Accessories", 
			"job.Custom_Cabinets AS job_Custom_Cabinets", 
			"job.Door_Style AS job_Door_Style", 
			"job.Wood AS job_Wood", 
			"job.Colour AS job_Colour", 
			"job.Material AS job_Material", 
			"job.Door_Vendor AS job_Door_Vendor", 
			"job.Door_ETA AS job_Door_ETA", 
			"job.Status AS job_Status");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				production.Full_Job_Number LIKE ? OR 
				production.Job_Number_Prefix LIKE ? OR 
				production.DJobNum LIKE ? OR 
				production.Job_Number LIKE ? OR 
				production.Job_Reviewed LIKE ? OR 
				production.RGA_Approval_Received LIKE ? OR 
				production.Material_Ordered LIKE ? OR 
				production.Material_ETA LIKE ? OR 
				production.Material_Received LIKE ? OR 
				production.Doors_Ordered LIKE ? OR 
				production.Door_ETA LIKE ? OR 
				production.Accessories_Ordered LIKE ? OR 
				production.Paint_Ordered LIKE ? OR 
				production.Finishing_Required LIKE ? OR 
				production.CUSTOM_FINISHED_PARTS LIKE ? OR 
				production.CUSTOM_UNFINISHED_PARTS LIKE ? OR 
				production.Job_Programmed LIKE ? OR 
				production.Doors_Received LIKE ? OR 
				production.Doors_Drilled LIKE ? OR 
				production.Accessories_Received LIKE ? OR 
				production.Finished_Parts_CNC LIKE ? OR 
				production.Finished_Parts_Banded_Doweled LIKE ? OR 
				production.Custom_Parts_Completed LIKE ? OR 
				production.Parts_ready_for_Finishing LIKE ? OR 
				production.Finished_Parts_Complete LIKE ? OR 
				production.Unfinished_Parts_CNC LIKE ? OR 
				production.Unfinished_Parts_Complete LIKE ? OR 
				production.Cabinets_Assembled LIKE ? OR 
				production.Cabinets_Wrapped LIKE ? OR 
				production.Packages_Wrapped LIKE ? OR 
				production.Job_Ready_to_Ship LIKE ? OR 
				production.Drawer_Type LIKE ? OR 
				production.Finished_End_Sq_Ft LIKE ? OR 
				production.Door_Sq_Ft LIKE ? OR 
				production.MDF_SHEET_QUANTITY LIKE ? OR 
				production.MEL_SHEET_QUANTITY LIKE ? OR 
				production.FIN_SHEET_QUANTITY LIKE ? OR 
				production.Job_Reviewed_TS LIKE ? OR 
				production.RGA_Approval_Received_TS LIKE ? OR 
				production.Material_Ordered_TS LIKE ? OR 
				production.Material_Received_TS LIKE ? OR 
				production.Doors_Ordered_TS LIKE ? OR 
				production.Accessories_Ordered_TS LIKE ? OR 
				production.Paint_Ordered_TS LIKE ? OR 
				production.Finishing_Required_TS LIKE ? OR 
				production.CUSTOM_FINISHED_PARTS_TS LIKE ? OR 
				production.CUSTOM_UNFINISHED_PARTS_TS LIKE ? OR 
				production.Job_Programmed_TS LIKE ? OR 
				production.Doors_Received_TS LIKE ? OR 
				production.Doors_Drilled_TS LIKE ? OR 
				production.Accessories_Received_TS LIKE ? OR 
				production.Finished_Parts_CNC_TS LIKE ? OR 
				production.Finished_Parts_Banded_Doweled_TS LIKE ? OR 
				production.Custom_Parts_Completed_TS LIKE ? OR 
				production.Parts_ready_for_Finishing_TS LIKE ? OR 
				production.Finished_Parts_Complete_TS LIKE ? OR 
				production.Unfinished_Parts_CNC_TS LIKE ? OR 
				production.Unfinished_Parts_Complete_TS LIKE ? OR 
				production.Cabinets_Assembled_TS LIKE ? OR 
				production.Cabinets_Wrapped_TS LIKE ? OR 
				production.Packages_Wrapped_TS LIKE ? OR 
				production.Job_Ready_to_Ship_TS LIKE ? OR 
				production.pk_Production LIKE ? OR 
				job.Job_Number_Prefix LIKE ? OR 
				job.Job_Number LIKE ? OR 
				job.Dealer LIKE ? OR 
				job.Customer_PO LIKE ? OR 
				job.Tag_Name LIKE ? OR 
				job.Received_Order LIKE ? OR 
				job.Original_Job_Number LIKE ? OR 
				job.Description LIKE ? OR 
				job.OE LIKE ? OR 
				job.Sales_Rep LIKE ? OR 
				job.Requested_Date LIKE ? OR 
				job.Value LIKE ? OR 
				job.Sent_To_OE LIKE ? OR 
				job.Sent_For_Confirmation LIKE ? OR 
				job.Confirmation_Received LIKE ? OR 
				job.Confirmed LIKE ? OR 
				job.Sent_To_Plant LIKE ? OR 
				job.To_Plant LIKE ? OR 
				job.Confirmed_Ship_Date LIKE ? OR 
				job.Invoiced LIKE ? OR 
				job.TimeStamp LIKE ? OR 
				job.Job_Type LIKE ? OR 
				job.Uppers LIKE ? OR 
				job.Talls LIKE ? OR 
				job.Bases LIKE ? OR 
				job.Vanities LIKE ? OR 
				job.Accessories LIKE ? OR 
				job.Custom_Cabinets LIKE ? OR 
				job.Door_Style LIKE ? OR 
				job.Wood LIKE ? OR 
				job.Colour LIKE ? OR 
				job.Material LIKE ? OR 
				job.Door_Vendor LIKE ? OR 
				job.Door_ETA LIKE ? OR 
				job.Date_Shipped LIKE ? OR 
				job.Back_Orders LIKE ? OR 
				job.Back_Orders_Shipped LIKE ? OR 
				job.Proposed_Shipping_Date LIKE ? OR 
				job.Lead_Time LIKE ? OR 
				job.Status LIKE ? OR 
				job.Creator LIKE ? OR 
				job.Dealer_Route LIKE ? OR 
				job.Updated_By LIKE ? OR 
				job.Last_Updated LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "production/search.php";
		}
		$db->join("job", "production.Job_Number = job.Job_Number", "RIGHT");
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("production.pk_Production", ORDER_TYPE);
		}
		$db->where("Where `production`.Job_Number = NULL");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Production";
		$view_name = (is_ajax() ? "production/ajax-prod_checks.php" : "production/prod_checks.php");
		$this->render_view($view_name, $data);
	}
}
