<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Accounting</h4>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('accounting/'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('accounting'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('accounting'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="accounting-nia-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-DJobNum"> Job.#</th>
                                                <th  class="td-Paid"> Paid</th>
                                                <th  class="td-Invoiced"> Invoiced</th>
                                                <th  class="td-Note"> Note</th>
                                                <th  class="td-job_Dealer"> Job Dealer</th>
                                                <th  class="td-job_Customer_PO"> Job Customer Po</th>
                                                <th  class="td-job_Tag_Name"> Job Tag Name</th>
                                                <th  class="td-job_Received_Order"> Job Received Order</th>
                                                <th  class="td-job_Original_Job_Number"> Job Original Job Number</th>
                                                <th  class="td-job_Description"> Job Description</th>
                                                <th  class="td-job_OE"> Job Oe</th>
                                                <th  class="td-job_Sales_Rep"> Job Sales Rep</th>
                                                <th  class="td-job_Requested_Date"> Job Requested Date</th>
                                                <th  class="td-job_Value"> Job Value</th>
                                                <th  class="td-job_Sent_To_OE"> Job Sent To Oe</th>
                                                <th  class="td-job_Sent_For_Confirmation"> Job Sent For Confirmation</th>
                                                <th  class="td-job_Confirmation_Received"> Job Confirmation Received</th>
                                                <th  class="td-job_Sent_To_Plant"> Job Sent To Plant</th>
                                                <th  class="td-job_To_Plant"> Job To Plant</th>
                                                <th  class="td-job_Confirmed_Ship_Date"> Job Confirmed Ship Date</th>
                                                <th  class="td-job_Job_Type"> Job Job Type</th>
                                                <th  class="td-job_Status"> Job Status</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['Job_Number']) ? urlencode($data['Job_Number']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <td class="td-DJobNum"><a href="<?php print_link("../../joblist/fulleditform.php?Refresh=1&JobNum=$rec_id") ?>"><?php echo $data['DJobNum']; ?></a></td>
                                                <td class="td-Paid">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Paid']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Paid" 
                                                        data-title="Enter Paid" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Paid']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Invoiced">
                                                    <span  data-source='[{value: "Y", label: "Y"},{value: "N", label: "N"}]' 
                                                        data-value="<?php echo $data['Invoiced']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("accounting/editfield/" . urlencode($data['JobNum'])); ?>" 
                                                        data-name="Invoiced" 
                                                        data-title="Enter Invoiced" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="radiolist" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Invoiced']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Note">
                                                    <?php
                                                    $page_fields = array('Job_Number' => $data['Job_Number']);
                                                    $page_link = "masterdetail/index/accounting/accounting_notes/Job_Number/" . urlencode($data['Job_Number']);
                                                    $md_pagelink = set_page_link($page_link, $page_fields); 
                                                    ?>
                                                    <a size="sm" class="btn btn-sm btn-primary page-modal" href="<?php print_link($md_pagelink) ?>">
                                                        <i class="icon dripicons-preview"></i> <?php echo $data['Note'] ?>
                                                    </a>
                                                </td>
                                                <td class="td-job_Dealer">
                                                    <span  data-source='<?php print_link('api/json/accounting_job_Dealer_option_list'); ?>' 
                                                        data-value="<?php echo $data['job_Dealer']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Dealer" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Dealer']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Customer_PO">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Customer_PO" 
                                                        data-title="Enter Customer PO" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Customer_PO']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Tag_Name">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Tag_Name" 
                                                        data-title="Enter Tag Name" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Tag_Name']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Received_Order">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Received_Order']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Received_Order" 
                                                        data-title="Enter Received Order" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Received_Order']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Original_Job_Number">
                                                    <span  data-value="<?php echo $data['job_Original_Job_Number']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Original_Job_Number" 
                                                        data-title="Enter Original Job Number" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Original_Job_Number']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Description">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Description" 
                                                        data-title="Enter Description" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Description']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_OE">
                                                    <span  data-source='<?php print_link('api/json/accounting_job_OE_option_list'); ?>' 
                                                        data-value="<?php echo $data['job_OE']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="OE" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_OE']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Sales_Rep"> <?php echo $data['job_Sales_Rep']; ?></td>
                                                <td class="td-job_Requested_Date">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Requested_Date']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Requested_Date" 
                                                        data-title="Enter Requested Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Requested_Date']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Value">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['job_Value']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Value']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Sent_To_OE">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Sent_To_OE']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_To_OE" 
                                                        data-title="Enter Sent To Oe" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Sent_To_OE']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Sent_For_Confirmation">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Sent_For_Confirmation']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_For_Confirmation" 
                                                        data-title="Enter Sent For Confirmation" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Sent_For_Confirmation']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Confirmation_Received">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Confirmation_Received']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Confirmation_Received" 
                                                        data-title="Enter Confirmation Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Confirmation_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Sent_To_Plant">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Sent_To_Plant']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_To_Plant" 
                                                        data-title="Enter Sent To Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Sent_To_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_To_Plant">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['job_To_Plant']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="To_Plant" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_To_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Confirmed_Ship_Date">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['job_Confirmed_Ship_Date']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Confirmed_Ship_Date" 
                                                        data-title="Enter Confirmed Ship Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Confirmed_Ship_Date']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Job_Type">
                                                    <span  data-source='<?php print_link('api/json/accounting_job_Job_Type_option_list'); ?>' 
                                                        data-value="<?php echo $data['job_Job_Type']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Job_Type" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Job_Type']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-job_Status">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Status); ?>' 
                                                        data-value="<?php echo $data['job_Status']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['job_Status']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
