<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page ajax-page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Jobs List For Order Entry</h4>
                </div>
                <div class="col-sm-3 ">
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("job/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Job 
                    </a>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('job'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('job'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="job-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <?php Html::ajaxpage_spinner(); ?>
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-Job_Number_Prefix"> Job Number Prefix</th>
                                                <th  class="td-Job_Number"> Job Number</th>
                                                <th  class="td-Dealer"> Dealer</th>
                                                <th  class="td-Customer_PO"> Customer Po</th>
                                                <th  class="td-Tag_Name"> Tag Name</th>
                                                <th  class="td-Received_Order"> Received Order</th>
                                                <th  class="td-Original_Job_Number"> Original Job Number</th>
                                                <th  class="td-Description"> Description</th>
                                                <th  class="td-OE"> Oe</th>
                                                <th  class="td-Sales_Rep"> Sales Rep</th>
                                                <th  class="td-Requested_Date"> Requested Date</th>
                                                <th  class="td-Value"> Value</th>
                                                <th  class="td-Sent_To_OE"> Sent To Oe</th>
                                                <th  class="td-Sent_For_Confirmation"> Sent For Confirmation</th>
                                                <th  class="td-Confirmation_Received"> Confirmation Received</th>
                                                <th  class="td-Confirmed"> Confirmed</th>
                                                <th  class="td-Sent_To_Plant"> Sent To Plant</th>
                                                <th  class="td-To_Plant"> To Plant</th>
                                                <th  class="td-Confirmed_Ship_Date"> Confirmed Ship Date</th>
                                                <th  class="td-Invoiced"> Invoiced</th>
                                                <th  class="td-TimeStamp"> Timestamp</th>
                                                <th  class="td-Job_Type"> Job Type</th>
                                                <th  class="td-Uppers"> Uppers</th>
                                                <th  class="td-Talls"> Talls</th>
                                                <th  class="td-Bases"> Bases</th>
                                                <th  class="td-Vanities"> Vanities</th>
                                                <th  class="td-Accessories"> Accessories</th>
                                                <th  class="td-Door_Style"> Door Style</th>
                                                <th  class="td-Wood"> Wood</th>
                                                <th  class="td-Colour"> Colour</th>
                                                <th  class="td-Material"> Material</th>
                                                <th  class="td-Door_Vendor"> Door Vendor</th>
                                                <th  class="td-Door_ETA"> Door Eta</th>
                                                <th  class="td-Date_Shipped"> Date Shipped</th>
                                                <th  class="td-Back_Orders"> Back Orders</th>
                                                <th  class="td-Back_Orders_Shipped"> Back Orders Shipped</th>
                                                <th  class="td-Proposed_Shipping_Date"> Proposed Shipping Date</th>
                                                <th  class="td-Lead_Time"> Lead Time</th>
                                                <th  class="td-Status"> Status</th>
                                                <th  class="td-Creator"> Creator</th>
                                                <th  class="td-Dealer_Route"> Dealer Route</th>
                                                <th  class="td-Updated_By"> Updated By</th>
                                                <th  class="td-Last_Updated"> Last Updated</th>
                                                <th  class="td-Custom_Cabinets"> Custom Cabinets</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['Job_Number']) ? urlencode($data['Job_Number']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("job/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("job/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                </th>
                                                <td class="td-Job_Number_Prefix">
                                                    <span  data-source='<?php print_link('api/json/job_Job_Number_Prefix_option_list'); ?>' 
                                                        data-value="<?php echo $data['Job_Number_Prefix']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Job_Number_Prefix" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Job_Number_Prefix']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Job_Number"><a href="<?php print_link("job/view/$data[Job_Number]") ?>"><?php echo $data['Job_Number']; ?></a></td>
                                                <td class="td-Dealer">
                                                    <span  data-source='<?php print_link('api/json/job_Dealer_option_list'); ?>' 
                                                        data-value="<?php echo $data['Dealer']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Dealer" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Dealer']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Customer_PO">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Customer_PO" 
                                                        data-title="Enter Customer PO" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Customer_PO']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Tag_Name">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Tag_Name" 
                                                        data-title="Enter Tag Name" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Tag_Name']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Received_Order">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Received_Order']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Received_Order" 
                                                        data-title="Enter Received Order" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Received_Order']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Original_Job_Number">
                                                    <span  data-value="<?php echo $data['Original_Job_Number']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Original_Job_Number" 
                                                        data-title="Enter Original Job Number" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Original_Job_Number']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Description">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Description" 
                                                        data-title="Enter Description" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Description']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-OE">
                                                    <span  data-source='<?php print_link('api/json/job_OE_option_list'); ?>' 
                                                        data-value="<?php echo $data['OE']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="OE" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['OE']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Sales_Rep"> <?php echo $data['Sales_Rep']; ?></td>
                                                <td class="td-Requested_Date">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Requested_Date']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Requested_Date" 
                                                        data-title="Enter Requested Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Requested_Date']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Value">
                                                    <span  data-step="0.1" 
                                                        data-value="<?php echo $data['Value']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Value" 
                                                        data-title="Enter Value" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Value']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Sent_To_OE">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_To_OE']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_To_OE" 
                                                        data-title="Enter Sent To Oe" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Sent_To_OE']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Sent_For_Confirmation">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_For_Confirmation']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_For_Confirmation" 
                                                        data-title="Enter Sent For Confirmation" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Sent_For_Confirmation']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Confirmation_Received">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Confirmation_Received']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Confirmation_Received" 
                                                        data-title="Enter Confirmation Received" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Confirmation_Received']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Confirmed">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['Confirmed']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Confirmed" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Confirmed']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Sent_To_Plant">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Sent_To_Plant']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Sent_To_Plant" 
                                                        data-title="Enter Sent To Plant" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Sent_To_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-To_Plant">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['To_Plant']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="To_Plant" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['To_Plant']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Confirmed_Ship_Date">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Confirmed_Ship_Date']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Confirmed_Ship_Date" 
                                                        data-title="Enter Confirmed Ship Date" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Confirmed_Ship_Date']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Invoiced">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Artisan); ?>' 
                                                        data-value="<?php echo $data['Invoiced']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Invoiced" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Invoiced']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-TimeStamp"> <?php echo $data['TimeStamp']; ?></td>
                                                <td class="td-Job_Type">
                                                    <span  data-source='<?php print_link('api/json/job_Job_Type_option_list'); ?>' 
                                                        data-value="<?php echo $data['Job_Type']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Job_Type" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Job_Type']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Uppers">
                                                    <span  data-value="<?php echo $data['Uppers']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Uppers" 
                                                        data-title="Enter Uppers" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Uppers']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Talls">
                                                    <span  data-value="<?php echo $data['Talls']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Talls" 
                                                        data-title="Enter Talls" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Talls']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Bases">
                                                    <span  data-value="<?php echo $data['Bases']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Bases" 
                                                        data-title="Enter Bases" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Bases']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Vanities">
                                                    <span  data-value="<?php echo $data['Vanities']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Vanities" 
                                                        data-title="Enter Vanities" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Vanities']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Accessories">
                                                    <span  data-value="<?php echo $data['Accessories']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Accessories" 
                                                        data-title="Enter Accessories" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="number" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Accessories']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Door_Style">
                                                    <span  data-source='<?php print_link('api/json/job_Door_Style_option_list'); ?>' 
                                                        data-value="<?php echo $data['Door_Style']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Door_Style" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_Style']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Wood">
                                                    <span  data-source='<?php print_link('api/json/job_Wood_option_list'); ?>' 
                                                        data-value="<?php echo $data['Wood']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Wood" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Wood']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Colour">
                                                    <span  data-source='<?php print_link('api/json/job_Colour_option_list'); ?>' 
                                                        data-value="<?php echo $data['Colour']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Colour" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Colour']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Material"> <?php echo $data['Material']; ?></td>
                                                <td class="td-Door_Vendor">
                                                    <span  data-source='<?php print_link('api/json/job_Door_Vendor_option_list'); ?>' 
                                                        data-value="<?php echo $data['Door_Vendor']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Door_Vendor" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_Vendor']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Door_ETA">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Door_ETA']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Door_ETA" 
                                                        data-title="Enter Door Eta" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Door_ETA']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Date_Shipped">
                                                    <span  data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Date_Shipped']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Date_Shipped" 
                                                        data-title="Enter Date Shipped" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Date_Shipped']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Back_Orders"> <?php echo $data['Back_Orders']; ?></td>
                                                <td class="td-Back_Orders_Shipped"> <?php echo $data['Back_Orders_Shipped']; ?></td>
                                                <td class="td-Proposed_Shipping_Date"> <?php echo $data['Proposed_Shipping_Date']; ?></td>
                                                <td class="td-Lead_Time"> <?php echo $data['Lead_Time']; ?></td>
                                                <td class="td-Status">
                                                    <span  data-source='<?php echo json_encode_quote(Menu :: $Status); ?>' 
                                                        data-value="<?php echo $data['Status']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Status']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Creator">
                                                    <span  data-source='<?php print_link('api/json/job_Creator_option_list'); ?>' 
                                                        data-value="<?php echo $data['Creator']; ?>" 
                                                        data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Creator" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Creator']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Dealer_Route"> <?php echo $data['Dealer_Route']; ?></td>
                                                <td class="td-Updated_By"> <?php echo $data['Updated_By']; ?></td>
                                                <td class="td-Last_Updated"> <?php echo $data['Last_Updated']; ?></td>
                                                <td class="td-Custom_Cabinets">
                                                    <span  data-pk="<?php echo $data['Job_Number'] ?>" 
                                                        data-url="<?php print_link("job/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Custom_Cabinets" 
                                                        data-title="Enter Custom Cabinets" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="textarea" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" >
                                                        <?php echo $data['Custom_Cabinets']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->ajax_page = true;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
