<?php 
/**
 * Backorder Page Controller
 * @category  Controller
 */
class BackorderController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "backorder";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) AS BO_No", 
			"Other_ETA", 
			"Job_Number", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Value", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Status", 
			"BO_ID");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) LIKE ? OR 
				backorder.Other_ETA LIKE ? OR 
				backorder.Full_Job_Number LIKE ? OR 
				backorder.Job_Type LIKE ? OR 
				backorder.Job_Number_Prefix LIKE ? OR 
				backorder.Job_Number LIKE ? OR 
				backorder.Production_Received LIKE ? OR 
				backorder.Dealer LIKE ? OR 
				backorder.Customer_PO LIKE ? OR 
				backorder.Tag_Name LIKE ? OR 
				backorder.Order_Entry LIKE ? OR 
				backorder.Received_Order LIKE ? OR 
				backorder.Requested_Date LIKE ? OR 
				backorder.Sent_To_OE LIKE ? OR 
				backorder.Sent_For_Confirmation LIKE ? OR 
				backorder.Confirmation_Received LIKE ? OR 
				backorder.Confirmed LIKE ? OR 
				backorder.Sent_To_Plant LIKE ? OR 
				backorder.Invoiced LIKE ? OR 
				backorder.Value LIKE ? OR 
				backorder.Uppers LIKE ? OR 
				backorder.Talls LIKE ? OR 
				backorder.Bases LIKE ? OR 
				backorder.Vanities LIKE ? OR 
				backorder.Accessories LIKE ? OR 
				backorder.Door_Style LIKE ? OR 
				backorder.Wood LIKE ? OR 
				backorder.Colour LIKE ? OR 
				backorder.Comments LIKE ? OR 
				backorder.Original_Job_Number LIKE ? OR 
				backorder.Door_Vendor LIKE ? OR 
				backorder.Door_ETA LIKE ? OR 
				backorder.Standard_Lead_Time LIKE ? OR 
				backorder.Date_Shipped LIKE ? OR 
				backorder.Back_Orders LIKE ? OR 
				backorder.Back_Orders_Shipped LIKE ? OR 
				backorder.Proposed_Shipping_Date LIKE ? OR 
				backorder.Shipping_Comments LIKE ? OR 
				backorder.Shipping_Details LIKE ? OR 
				backorder.Dealer_Route LIKE ? OR 
				backorder.Sales_Rep LIKE ? OR 
				backorder.Creator LIKE ? OR 
				backorder.Updated_By LIKE ? OR 
				backorder.Created_TS LIKE ? OR 
				backorder.Last_Updated_TS LIKE ? OR 
				backorder.Status LIKE ? OR 
				backorder.BO_ID LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "backorder/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("backorder.BO_ID", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Backorders";
		$this->render_view("backorder/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("Full_Job_Number", 
			"Job_Type", 
			"Job_Number_Prefix", 
			"Job_Number", 
			"Production_Received", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Order_Entry", 
			"Received_Order", 
			"Requested_Date", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"Invoiced", 
			"Value", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Comments", 
			"Original_Job_Number", 
			"Door_Vendor", 
			"Door_ETA", 
			"Other_ETA", 
			"Standard_Lead_Time", 
			"Date_Shipped", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Shipping_Comments", 
			"Shipping_Details", 
			"Dealer_Route", 
			"Sales_Rep", 
			"Creator", 
			"Updated_By", 
			"Created_TS", 
			"Last_Updated_TS", 
			"Status", 
			"BO_ID");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("backorder.BO_ID", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Backorder";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("backorder/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Other_ETA","Back_Orders","Proposed_Shipping_Date","BO_ID");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Type' => 'required',
				'Job_Number_Prefix' => 'required',
				'Job_Number' => 'required',
				'Other_ETA' => 'required',
				'Back_Orders' => 'required',
				'Proposed_Shipping_Date' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			$modeldata['BO_ID'] = "NULL";
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
		# Statement to execute after adding record
		$db->rawQuery("update `backorder` t1 join `job` t2 ON t1.`Job_Number` = t2.`Job_Number` set t1.`Dealer` = t2.`Dealer`, t1.`Tag_Name` = t2.`Tag_Name`, t1.`Door_Style` = t2.`Door_Style`, t1.`Wood`=t2.`Wood` Where BO_ID='". $rec_id ."'");
		# End of after add statement
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("backorder/edit/$rec_id");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Backorder";
		$this->render_view("backorder/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Other_ETA","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Status");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Type' => 'required',
				'Job_Number_Prefix' => 'required',
				'Job_Number' => 'required',
				'Other_ETA' => 'required',
				'Back_Orders' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("backorder.BO_ID", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("backorder/view/$rec_id");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						$this->write_to_log("edit", "false");
						return	$this->redirect("backorder/view/$rec_id");
					}
				}
			}
		}
		$db->where("backorder.BO_ID", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Backorder";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("backorder/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Other_ETA","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Status");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Job_Type' => 'required',
				'Job_Number_Prefix' => 'required',
				'Job_Number' => 'required',
				'Other_ETA' => 'required',
				'Back_Orders' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("backorder.BO_ID", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("backorder.BO_ID", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->write_to_log("delete", "true");
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
			$this->write_to_log("delete", "false");
		}
		return	$this->redirect("backorder");
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add_from($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("Job_Type","Job_Number_Prefix","Job_Number","Dealer","Customer_PO","Tag_Name","Door_Style","Wood","Colour","Comments","Status");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'Job_Type' => 'required',
				'Job_Number_Prefix' => 'required',
				'Job_Number' => 'required',
				'Dealer' => 'required',
				'Customer_PO' => 'required',
				'Tag_Name' => 'required',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Job_Type' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
				'Job_Number' => 'sanitize_string',
				'Dealer' => 'sanitize_string',
				'Customer_PO' => 'sanitize_string',
				'Tag_Name' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			//Check if Duplicate Record Already Exit In The Database
			$db->where("Job_Number", $modeldata['Job_Number']);
			if($db->has($tablename)){
				$this->view->page_error[] = $modeldata['Job_Number']." Already exist!";
			} 
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("BackOrder added successfully", "success");
					return	$this->redirect("backorder");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Backorder";
		$this->render_view("backorder/add_from.php");
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function l_follow_up($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) AS BO_No", 
			"Other_ETA", 
			"Job_Number", 
			"Dealer", 
			"Customer_PO", 
			"Tag_Name", 
			"Value", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Status", 
			"BO_ID");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				Concat(Job_Number_Prefix,trim(TRAILING '.' FROM (trim(TRAILING '0' FROM Job_Number)))) LIKE ? OR 
				backorder.Other_ETA LIKE ? OR 
				backorder.Full_Job_Number LIKE ? OR 
				backorder.Job_Type LIKE ? OR 
				backorder.Job_Number_Prefix LIKE ? OR 
				backorder.Job_Number LIKE ? OR 
				backorder.Production_Received LIKE ? OR 
				backorder.Dealer LIKE ? OR 
				backorder.Customer_PO LIKE ? OR 
				backorder.Tag_Name LIKE ? OR 
				backorder.Order_Entry LIKE ? OR 
				backorder.Received_Order LIKE ? OR 
				backorder.Requested_Date LIKE ? OR 
				backorder.Sent_To_OE LIKE ? OR 
				backorder.Sent_For_Confirmation LIKE ? OR 
				backorder.Confirmation_Received LIKE ? OR 
				backorder.Confirmed LIKE ? OR 
				backorder.Sent_To_Plant LIKE ? OR 
				backorder.Invoiced LIKE ? OR 
				backorder.Value LIKE ? OR 
				backorder.Uppers LIKE ? OR 
				backorder.Talls LIKE ? OR 
				backorder.Bases LIKE ? OR 
				backorder.Vanities LIKE ? OR 
				backorder.Accessories LIKE ? OR 
				backorder.Door_Style LIKE ? OR 
				backorder.Wood LIKE ? OR 
				backorder.Colour LIKE ? OR 
				backorder.Comments LIKE ? OR 
				backorder.Original_Job_Number LIKE ? OR 
				backorder.Door_Vendor LIKE ? OR 
				backorder.Door_ETA LIKE ? OR 
				backorder.Standard_Lead_Time LIKE ? OR 
				backorder.Date_Shipped LIKE ? OR 
				backorder.Back_Orders LIKE ? OR 
				backorder.Back_Orders_Shipped LIKE ? OR 
				backorder.Proposed_Shipping_Date LIKE ? OR 
				backorder.Shipping_Comments LIKE ? OR 
				backorder.Shipping_Details LIKE ? OR 
				backorder.Dealer_Route LIKE ? OR 
				backorder.Sales_Rep LIKE ? OR 
				backorder.Creator LIKE ? OR 
				backorder.Updated_By LIKE ? OR 
				backorder.Created_TS LIKE ? OR 
				backorder.Last_Updated_TS LIKE ? OR 
				backorder.Status LIKE ? OR 
				backorder.BO_ID LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "backorder/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("backorder.BO_ID", ORDER_TYPE);
		}
		$db->where("`Other_ETA`<= now()");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Backorders";
		$this->render_view("backorder/l_follow_up.php", $data); //render the full page
	}
}
