<?php 
/**
 * Jlv2_jl_5_joblist_pre2020 Page Controller
 * @category  Controller
 */
class Jlv2_jl_5_joblist_pre2020Controller extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jlv2_jl_5_joblist_pre2020";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Dealer", 
			"TagName", 
			"Customer_Number", 
			"RSO", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Comments", 
			"Requested_Date", 
			"Received_Order", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"Plant", 
			"Inv", 
			"OE", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Value", 
			"Door_Vendor", 
			"Standard_Lead_Time", 
			"Date_Shipped", 
			"Other_ETA", 
			"Door_ETA", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Shipping_Comments", 
			"Shipping_Details", 
			"DealerRoute", 
			"NJobNum", 
			"OrgJobNum", 
			"Creator", 
			"UpdatedBy", 
			"SalesRep", 
			"TimeStamp", 
			"LastUpdated", 
			"Status");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jlv2_jl_5_joblist_pre2020.JobNum LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Dealer LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.TagName LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Customer_Number LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.RSO LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Door_Style LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Wood LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Colour LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Comments LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Requested_Date LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Received_Order LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Sent_To_OE LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Sent_For_Confirmation LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Confirmation_Received LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Confirmed LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Sent_To_Plant LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Plant LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Inv LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.OE LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Uppers LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Talls LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Bases LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Vanities LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Accessories LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Value LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Door_Vendor LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Standard_Lead_Time LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Date_Shipped LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Other_ETA LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Door_ETA LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Back_Orders LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Back_Orders_Shipped LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Proposed_Shipping_Date LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Shipping_Comments LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Shipping_Details LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.DealerRoute LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.NJobNum LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.OrgJobNum LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Creator LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.UpdatedBy LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.SalesRep LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.TimeStamp LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.LastUpdated LIKE ? OR 
				jlv2_jl_5_joblist_pre2020.Status LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jlv2_jl_5_joblist_pre2020/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jlv2_jl_5_joblist_pre2020.JobNum", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Old Jobs";
		$this->render_view("jlv2_jl_5_joblist_pre2020/list.php", $data); //render the full page
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Dealer", 
			"TagName", 
			"Customer_Number", 
			"RSO", 
			"Door_Style", 
			"Wood", 
			"Colour", 
			"Comments", 
			"Requested_Date", 
			"Received_Order", 
			"Sent_To_OE", 
			"Sent_For_Confirmation", 
			"Confirmation_Received", 
			"Confirmed", 
			"Sent_To_Plant", 
			"Plant", 
			"Inv", 
			"OE", 
			"Uppers", 
			"Talls", 
			"Bases", 
			"Vanities", 
			"Accessories", 
			"Value", 
			"Door_Vendor", 
			"Standard_Lead_Time", 
			"Date_Shipped", 
			"Other_ETA", 
			"Door_ETA", 
			"Back_Orders", 
			"Back_Orders_Shipped", 
			"Proposed_Shipping_Date", 
			"Shipping_Comments", 
			"Shipping_Details", 
			"DealerRoute", 
			"NJobNum", 
			"OrgJobNum", 
			"Creator", 
			"UpdatedBy", 
			"SalesRep", 
			"TimeStamp", 
			"LastUpdated", 
			"Status");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("jlv2_jl_5_joblist_pre2020.JobNum", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Old Job";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("jlv2_jl_5_joblist_pre2020/view.php", $record);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("JobNum","Dealer","TagName","Customer_Number","RSO","Door_Style","Wood","Colour","Comments","Requested_Date","Received_Order","Sent_To_OE","Sent_For_Confirmation","Confirmation_Received","Confirmed","Sent_To_Plant","Plant","Inv","OE","Uppers","Talls","Bases","Vanities","Accessories","Value","Door_Vendor","Standard_Lead_Time","Date_Shipped","Other_ETA","Door_ETA","Back_Orders","Back_Orders_Shipped","Proposed_Shipping_Date","Shipping_Comments","Shipping_Details","DealerRoute","NJobNum","OrgJobNum","Creator","UpdatedBy","SalesRep","LastUpdated","Status");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'Dealer' => 'required',
				'TagName' => 'required',
				'Customer_Number' => 'required',
				'RSO' => 'required',
				'Door_Style' => 'required',
				'Wood' => 'required',
				'Colour' => 'required',
				'Comments' => 'required',
				'Requested_Date' => 'required',
				'Received_Order' => 'required',
				'Sent_To_OE' => 'required',
				'Sent_For_Confirmation' => 'required',
				'Confirmation_Received' => 'required',
				'Confirmed' => 'required',
				'Sent_To_Plant' => 'required',
				'Plant' => 'required',
				'Inv' => 'required',
				'OE' => 'required',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Value' => 'required|numeric',
				'Door_Vendor' => 'required',
				'Standard_Lead_Time' => 'required',
				'Date_Shipped' => 'required',
				'Other_ETA' => 'required',
				'Door_ETA' => 'required',
				'Back_Orders' => 'required',
				'Back_Orders_Shipped' => 'required',
				'Proposed_Shipping_Date' => 'required',
				'Shipping_Comments' => 'required',
				'Shipping_Details' => 'required',
				'DealerRoute' => 'required',
				'NJobNum' => 'required',
				'OrgJobNum' => 'required',
				'Creator' => 'required',
				'UpdatedBy' => 'required',
				'SalesRep' => 'required',
				'LastUpdated' => 'required',
				'Status' => 'required',
			);
			$this->sanitize_array = array(
				'Dealer' => 'sanitize_string',
				'TagName' => 'sanitize_string',
				'Customer_Number' => 'sanitize_string',
				'RSO' => 'sanitize_string',
				'Door_Style' => 'sanitize_string',
				'Wood' => 'sanitize_string',
				'Colour' => 'sanitize_string',
				'Comments' => 'sanitize_string',
				'Requested_Date' => 'sanitize_string',
				'Received_Order' => 'sanitize_string',
				'Sent_To_OE' => 'sanitize_string',
				'Sent_For_Confirmation' => 'sanitize_string',
				'Confirmation_Received' => 'sanitize_string',
				'Confirmed' => 'sanitize_string',
				'Sent_To_Plant' => 'sanitize_string',
				'Plant' => 'sanitize_string',
				'Inv' => 'sanitize_string',
				'OE' => 'sanitize_string',
				'Uppers' => 'sanitize_string',
				'Talls' => 'sanitize_string',
				'Bases' => 'sanitize_string',
				'Vanities' => 'sanitize_string',
				'Accessories' => 'sanitize_string',
				'Value' => 'sanitize_string',
				'Door_Vendor' => 'sanitize_string',
				'Standard_Lead_Time' => 'sanitize_string',
				'Date_Shipped' => 'sanitize_string',
				'Other_ETA' => 'sanitize_string',
				'Door_ETA' => 'sanitize_string',
				'Back_Orders' => 'sanitize_string',
				'Back_Orders_Shipped' => 'sanitize_string',
				'Proposed_Shipping_Date' => 'sanitize_string',
				'Shipping_Comments' => 'sanitize_string',
				'Shipping_Details' => 'sanitize_string',
				'DealerRoute' => 'sanitize_string',
				'NJobNum' => 'sanitize_string',
				'OrgJobNum' => 'sanitize_string',
				'Creator' => 'sanitize_string',
				'UpdatedBy' => 'sanitize_string',
				'SalesRep' => 'sanitize_string',
				'LastUpdated' => 'sanitize_string',
				'Status' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_5_joblist_pre2020.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
