<?php 
/**
 * Jlv2_jl_7_production_status Page Controller
 * @category  Controller
 */
class Jlv2_jl_7_production_statusController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "jlv2_jl_7_production_status";
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function index($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Ordered", 
			"Nested", 
			"Finished_Parts", 
			"Wrapped", 
			"Finishing", 
			"Unfinished_Parts", 
			"Assembled", 
			"tOrdered", 
			"tNested", 
			"tFinished_Parts", 
			"tWrapped", 
			"tFinishing", 
			"tUnfinished_Parts", 
			"tAssembled", 
			"sOrdered", 
			"sNested", 
			"sFinished_Parts", 
			"sWrapped", 
			"sFinishing", 
			"sUnfinished_Parts", 
			"sAssembled", 
			"Job_Number_Prefix");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jlv2_jl_7_production_status.JobNum LIKE ? OR 
				jlv2_jl_7_production_status.Ordered LIKE ? OR 
				jlv2_jl_7_production_status.Nested LIKE ? OR 
				jlv2_jl_7_production_status.Finished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.Wrapped LIKE ? OR 
				jlv2_jl_7_production_status.Finishing LIKE ? OR 
				jlv2_jl_7_production_status.Unfinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.Assembled LIKE ? OR 
				jlv2_jl_7_production_status.tOrdered LIKE ? OR 
				jlv2_jl_7_production_status.tNested LIKE ? OR 
				jlv2_jl_7_production_status.tFinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.tWrapped LIKE ? OR 
				jlv2_jl_7_production_status.tFinishing LIKE ? OR 
				jlv2_jl_7_production_status.tUnfinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.tAssembled LIKE ? OR 
				jlv2_jl_7_production_status.sOrdered LIKE ? OR 
				jlv2_jl_7_production_status.sNested LIKE ? OR 
				jlv2_jl_7_production_status.sFinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.sWrapped LIKE ? OR 
				jlv2_jl_7_production_status.sFinishing LIKE ? OR 
				jlv2_jl_7_production_status.sUnfinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.sAssembled LIKE ? OR 
				jlv2_jl_7_production_status.Job_Number_Prefix LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jlv2_jl_7_production_status/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jlv2_jl_7_production_status.JobNum", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Production Status";
		$view_name = (is_ajax() ? "jlv2_jl_7_production_status/ajax-list.php" : "jlv2_jl_7_production_status/list.php");
		$this->render_view($view_name, $data);
	}
	/**
     * View record detail 
	 * @param $rec_id (select record by table primary key) 
     * @param $value value (select record by value of field name(rec_id))
     * @return BaseView
     */
	function view($rec_id = null, $value = null){
		$request = $this->request;
		$db = $this->GetModel();
		$rec_id = $this->rec_id = urldecode($rec_id);
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Ordered", 
			"Nested", 
			"Finished_Parts", 
			"Wrapped", 
			"Finishing", 
			"Unfinished_Parts", 
			"Assembled", 
			"tOrdered", 
			"tNested", 
			"tFinished_Parts", 
			"tWrapped", 
			"tFinishing", 
			"tUnfinished_Parts", 
			"tAssembled", 
			"sOrdered", 
			"sNested", 
			"sFinished_Parts", 
			"sWrapped", 
			"sFinishing", 
			"sUnfinished_Parts", 
			"sAssembled", 
			"Job_Number_Prefix");
		if($value){
			$db->where($rec_id, urldecode($value)); //select record based on field name
		}
		else{
			$db->where("jlv2_jl_7_production_status.JobNum", $rec_id);; //select record based on primary key
		}
		$record = $db->getOne($tablename, $fields );
		if($record){
			$this->write_to_log("view", "true");
			$page_title = $this->view->page_title = "View  Jlv2 Jl 7 Production Status";
		}
		else{
			if($db->getLastError()){
				$this->set_page_error();
			}
			else{
				$this->set_page_error("No record found");
			}
			$this->write_to_log("view", "false");
		}
		return $this->render_view("jlv2_jl_7_production_status/view.php", $record);
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("JobNum","Ordered","Nested","Finished_Parts","Wrapped","Finishing","Unfinished_Parts","Assembled","tFinished_Parts","sOrdered","sNested","sFinished_Parts","sWrapped","sFinishing","sUnfinished_Parts","sAssembled","Job_Number_Prefix");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'JobNum' => 'required|numeric',
				'Ordered' => 'required',
				'Nested' => 'required',
				'Finished_Parts' => 'required',
				'Wrapped' => 'required',
				'Finishing' => 'required',
				'Unfinished_Parts' => 'required',
				'Assembled' => 'required',
				'sOrdered' => 'required',
				'sNested' => 'required',
				'sFinished_Parts' => 'required',
				'sWrapped' => 'required',
				'sFinishing' => 'required',
				'sUnfinished_Parts' => 'required',
				'sAssembled' => 'required',
				'Job_Number_Prefix' => 'required',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'Ordered' => 'sanitize_string',
				'Nested' => 'sanitize_string',
				'Finished_Parts' => 'sanitize_string',
				'Wrapped' => 'sanitize_string',
				'Finishing' => 'sanitize_string',
				'Unfinished_Parts' => 'sanitize_string',
				'Assembled' => 'sanitize_string',
				'tFinished_Parts' => 'sanitize_string',
				'sOrdered' => 'sanitize_string',
				'sNested' => 'sanitize_string',
				'sFinished_Parts' => 'sanitize_string',
				'sWrapped' => 'sanitize_string',
				'sFinishing' => 'sanitize_string',
				'sUnfinished_Parts' => 'sanitize_string',
				'sAssembled' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("jlv2_jl_7_production_status");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Jlv2 Jl 7 Production Status";
		$this->render_view("jlv2_jl_7_production_status/add.php");
	}
	/**
     * Update table record with formdata
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function edit($rec_id = null, $formdata = null){
		$request = $this->request;
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		 //editable fields
		$fields = $this->fields = array("JobNum","Ordered","Nested","Finished_Parts","Wrapped","Finishing","Unfinished_Parts","Assembled","tOrdered","tNested","tFinished_Parts","tWrapped","tFinishing","tUnfinished_Parts","tAssembled","sOrdered","sNested","sFinished_Parts","sWrapped","sFinishing","sUnfinished_Parts","sAssembled","Job_Number_Prefix");
		if($formdata){
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'JobNum' => 'required|numeric',
				'Ordered' => 'required',
				'Nested' => 'required',
				'Finished_Parts' => 'required',
				'Wrapped' => 'required',
				'Finishing' => 'required',
				'Unfinished_Parts' => 'required',
				'Assembled' => 'required',
				'sOrdered' => 'required',
				'sNested' => 'required',
				'sFinished_Parts' => 'required',
				'sWrapped' => 'required',
				'sFinishing' => 'required',
				'sUnfinished_Parts' => 'required',
				'sAssembled' => 'required',
				'Job_Number_Prefix' => 'required',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'Ordered' => 'sanitize_string',
				'Nested' => 'sanitize_string',
				'Finished_Parts' => 'sanitize_string',
				'Wrapped' => 'sanitize_string',
				'Finishing' => 'sanitize_string',
				'Unfinished_Parts' => 'sanitize_string',
				'Assembled' => 'sanitize_string',
				'tOrdered' => 'sanitize_string',
				'tNested' => 'sanitize_string',
				'tFinished_Parts' => 'sanitize_string',
				'tWrapped' => 'sanitize_string',
				'tFinishing' => 'sanitize_string',
				'tUnfinished_Parts' => 'sanitize_string',
				'tAssembled' => 'sanitize_string',
				'sOrdered' => 'sanitize_string',
				'sNested' => 'sanitize_string',
				'sFinished_Parts' => 'sanitize_string',
				'sWrapped' => 'sanitize_string',
				'sFinishing' => 'sanitize_string',
				'sUnfinished_Parts' => 'sanitize_string',
				'sAssembled' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
			);
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_7_production_status.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount(); //number of affected rows. 0 = no record field updated
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					$this->set_flash_msg("Record updated successfully", "success");
					return $this->redirect("jlv2_jl_7_production_status");
				}
				else{
					if($db->getLastError()){
						$this->set_page_error();
						$this->write_to_log("edit", "false");
					}
					elseif(!$numRows){
						//not an error, but no record was updated
						$page_error = "No record updated";
						$this->set_page_error($page_error);
						$this->set_flash_msg($page_error, "warning");
						$this->write_to_log("edit", "false");
						return	$this->redirect("jlv2_jl_7_production_status");
					}
				}
			}
		}
		$db->where("jlv2_jl_7_production_status.JobNum", $rec_id);;
		$data = $db->getOne($tablename, $fields);
		$page_title = $this->view->page_title = "Edit  Jlv2 Jl 7 Production Status";
		if(!$data){
			$this->set_page_error();
		}
		return $this->render_view("jlv2_jl_7_production_status/edit.php", $data);
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("JobNum","Ordered","Nested","Finished_Parts","Wrapped","Finishing","Unfinished_Parts","Assembled","tOrdered","tNested","tFinished_Parts","tWrapped","tFinishing","tUnfinished_Parts","tAssembled","sOrdered","sNested","sFinished_Parts","sWrapped","sFinishing","sUnfinished_Parts","sAssembled","Job_Number_Prefix");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'JobNum' => 'required|numeric',
				'Ordered' => 'required',
				'Nested' => 'required',
				'Finished_Parts' => 'required',
				'Wrapped' => 'required',
				'Finishing' => 'required',
				'Unfinished_Parts' => 'required',
				'Assembled' => 'required',
				'sOrdered' => 'required',
				'sNested' => 'required',
				'sFinished_Parts' => 'required',
				'sWrapped' => 'required',
				'sFinishing' => 'required',
				'sUnfinished_Parts' => 'required',
				'sAssembled' => 'required',
				'Job_Number_Prefix' => 'required',
			);
			$this->sanitize_array = array(
				'JobNum' => 'sanitize_string',
				'Ordered' => 'sanitize_string',
				'Nested' => 'sanitize_string',
				'Finished_Parts' => 'sanitize_string',
				'Wrapped' => 'sanitize_string',
				'Finishing' => 'sanitize_string',
				'Unfinished_Parts' => 'sanitize_string',
				'Assembled' => 'sanitize_string',
				'tOrdered' => 'sanitize_string',
				'tNested' => 'sanitize_string',
				'tFinished_Parts' => 'sanitize_string',
				'tWrapped' => 'sanitize_string',
				'tFinishing' => 'sanitize_string',
				'tUnfinished_Parts' => 'sanitize_string',
				'tAssembled' => 'sanitize_string',
				'sOrdered' => 'sanitize_string',
				'sNested' => 'sanitize_string',
				'sFinished_Parts' => 'sanitize_string',
				'sWrapped' => 'sanitize_string',
				'sFinishing' => 'sanitize_string',
				'sUnfinished_Parts' => 'sanitize_string',
				'sAssembled' => 'sanitize_string',
				'Job_Number_Prefix' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("jlv2_jl_7_production_status.JobNum", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
     * @return BaseView
     */
	function delete($rec_id = null){
		Csrf::cross_check();
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$this->rec_id = $rec_id;
		//form multiple delete, split record id separated by comma into array
		$arr_rec_id = array_map('trim', explode(",", $rec_id));
		$db->where("jlv2_jl_7_production_status.JobNum", $arr_rec_id, "in");
		$bool = $db->delete($tablename);
		if($bool){
			$this->write_to_log("delete", "true");
			$this->set_flash_msg("Record deleted successfully", "success");
		}
		elseif($db->getLastError()){
			$page_error = $db->getLastError();
			$this->set_flash_msg($page_error, "danger");
			$this->write_to_log("delete", "false");
		}
		return	$this->redirect("jlv2_jl_7_production_status");
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function production_station_list($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("JobNum", 
			"Ordered", 
			"Nested", 
			"Finished_Parts", 
			"Wrapped", 
			"Finishing", 
			"Unfinished_Parts", 
			"Assembled", 
			"tOrdered", 
			"tNested", 
			"tFinished_Parts", 
			"tWrapped", 
			"tFinishing", 
			"tUnfinished_Parts", 
			"tAssembled", 
			"sOrdered", 
			"sNested", 
			"sFinished_Parts", 
			"sWrapped", 
			"sFinishing", 
			"sUnfinished_Parts", 
			"sAssembled", 
			"Job_Number_Prefix");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				jlv2_jl_7_production_status.JobNum LIKE ? OR 
				jlv2_jl_7_production_status.Ordered LIKE ? OR 
				jlv2_jl_7_production_status.Nested LIKE ? OR 
				jlv2_jl_7_production_status.Finished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.Wrapped LIKE ? OR 
				jlv2_jl_7_production_status.Finishing LIKE ? OR 
				jlv2_jl_7_production_status.Unfinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.Assembled LIKE ? OR 
				jlv2_jl_7_production_status.tOrdered LIKE ? OR 
				jlv2_jl_7_production_status.tNested LIKE ? OR 
				jlv2_jl_7_production_status.tFinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.tWrapped LIKE ? OR 
				jlv2_jl_7_production_status.tFinishing LIKE ? OR 
				jlv2_jl_7_production_status.tUnfinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.tAssembled LIKE ? OR 
				jlv2_jl_7_production_status.sOrdered LIKE ? OR 
				jlv2_jl_7_production_status.sNested LIKE ? OR 
				jlv2_jl_7_production_status.sFinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.sWrapped LIKE ? OR 
				jlv2_jl_7_production_status.sFinishing LIKE ? OR 
				jlv2_jl_7_production_status.sUnfinished_Parts LIKE ? OR 
				jlv2_jl_7_production_status.sAssembled LIKE ? OR 
				jlv2_jl_7_production_status.Job_Number_Prefix LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "jlv2_jl_7_production_status/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("jlv2_jl_7_production_status.JobNum", ORDER_TYPE);
		}
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Production Status";
		$this->render_view("jlv2_jl_7_production_status/production_station_list.php", $data); //render the full page
	}
}
