<?php 
/**
 * Oc_deck_cards Page Controller
 * @category  Controller
 */
class Oc_deck_cardsController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "oc_deck_cards";
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("id","title","description","description_prev","stack_id","type","last_modified","last_editor","created_at","owner","order","archived","duedate","notified","deleted_at");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'title' => 'required',
				'description' => 'required',
				'description_prev' => 'required',
				'stack_id' => 'required|numeric',
				'type' => 'required',
				'last_modified' => 'required|numeric',
				'last_editor' => 'required',
				'created_at' => 'required|numeric',
				'owner' => 'required',
				'order' => 'required|numeric',
				'archived' => 'required|numeric',
				'duedate' => 'required',
				'notified' => 'required|numeric',
				'deleted_at' => 'required|numeric',
			);
			$this->sanitize_array = array(
				'title' => 'sanitize_string',
				'description' => 'sanitize_string',
				'description_prev' => 'sanitize_string',
				'stack_id' => 'sanitize_string',
				'type' => 'sanitize_string',
				'last_modified' => 'sanitize_string',
				'last_editor' => 'sanitize_string',
				'created_at' => 'sanitize_string',
				'owner' => 'sanitize_string',
				'order' => 'sanitize_string',
				'archived' => 'sanitize_string',
				'duedate' => 'sanitize_string',
				'notified' => 'sanitize_string',
				'deleted_at' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("oc_deck_cards.id", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
}
