<?php 
/**
 * Oc_filecache Page Controller
 * @category  Controller
 */
class Oc_filecacheController extends SecureController{
	function __construct(){
		parent::__construct();
		$this->tablename = "oc_filecache";
	}
	/**
     * Insert new record to the database table
	 * @param $formdata array() from $_POST
     * @return BaseView
     */
	function add($formdata = null){
		if($formdata){
			$db = $this->GetModel();
			$tablename = $this->tablename;
			$request = $this->request;
			//fillable fields
			$fields = $this->fields = array("storage","path","path_hash","parent","name","mimetype","mimepart","size","mtime","storage_mtime","encrypted","unencrypted_size","etag","permissions","checksum");
			$postdata = $this->format_request_data($formdata);
			$this->rules_array = array(
				'storage' => 'required|numeric',
				'path' => 'required',
				'path_hash' => 'required',
				'parent' => 'required|numeric',
				'name' => 'required',
				'mimetype' => 'required|numeric',
				'mimepart' => 'required|numeric',
				'size' => 'required|numeric',
				'mtime' => 'required|numeric',
				'storage_mtime' => 'required|numeric',
				'encrypted' => 'required|numeric',
				'unencrypted_size' => 'required|numeric',
				'etag' => 'required',
				'permissions' => 'required|numeric',
				'checksum' => 'required',
			);
			$this->sanitize_array = array(
				'storage' => 'sanitize_string',
				'path' => 'sanitize_string',
				'path_hash' => 'sanitize_string',
				'parent' => 'sanitize_string',
				'name' => 'sanitize_string',
				'mimetype' => 'sanitize_string',
				'mimepart' => 'sanitize_string',
				'size' => 'sanitize_string',
				'mtime' => 'sanitize_string',
				'storage_mtime' => 'sanitize_string',
				'encrypted' => 'sanitize_string',
				'unencrypted_size' => 'sanitize_string',
				'etag' => 'sanitize_string',
				'permissions' => 'sanitize_string',
				'checksum' => 'sanitize_string',
			);
			$this->filter_vals = true; //set whether to remove empty fields
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$rec_id = $this->rec_id = $db->insert($tablename, $modeldata);
				if($rec_id){
					$this->write_to_log("add", "true");
					$this->set_flash_msg("Record added successfully", "success");
					return	$this->redirect("oc_filecache");
				}
				else{
					$this->set_page_error();
					$this->write_to_log("add", "false");
				}
			}
		}
		$page_title = $this->view->page_title = "Add New Oc Filecache";
		$this->render_view("oc_filecache/add.php");
	}
	/**
     * Update single field
	 * @param $rec_id (select record by table primary key)
	 * @param $formdata array() from $_POST
     * @return array
     */
	function editfield($rec_id = null, $formdata = null){
		$db = $this->GetModel();
		$this->rec_id = $rec_id;
		$tablename = $this->tablename;
		//editable fields
		$fields = $this->fields = array("fileid","storage","path","path_hash","parent","name","mimetype","mimepart","size","mtime","storage_mtime","encrypted","unencrypted_size","etag","permissions","checksum");
		$page_error = null;
		if($formdata){
			$postdata = array();
			$fieldname = $formdata['name'];
			$fieldvalue = $formdata['value'];
			$postdata[$fieldname] = $fieldvalue;
			$postdata = $this->format_request_data($postdata);
			$this->rules_array = array(
				'storage' => 'required|numeric',
				'path' => 'required',
				'path_hash' => 'required',
				'parent' => 'required|numeric',
				'name' => 'required',
				'mimetype' => 'required|numeric',
				'mimepart' => 'required|numeric',
				'size' => 'required|numeric',
				'mtime' => 'required|numeric',
				'storage_mtime' => 'required|numeric',
				'encrypted' => 'required|numeric',
				'unencrypted_size' => 'required|numeric',
				'etag' => 'required',
				'permissions' => 'required|numeric',
				'checksum' => 'required',
			);
			$this->sanitize_array = array(
				'storage' => 'sanitize_string',
				'path' => 'sanitize_string',
				'path_hash' => 'sanitize_string',
				'parent' => 'sanitize_string',
				'name' => 'sanitize_string',
				'mimetype' => 'sanitize_string',
				'mimepart' => 'sanitize_string',
				'size' => 'sanitize_string',
				'mtime' => 'sanitize_string',
				'storage_mtime' => 'sanitize_string',
				'encrypted' => 'sanitize_string',
				'unencrypted_size' => 'sanitize_string',
				'etag' => 'sanitize_string',
				'permissions' => 'sanitize_string',
				'checksum' => 'sanitize_string',
			);
			$this->filter_rules = true; //filter validation rules by excluding fields not in the formdata
			$modeldata = $this->modeldata = $this->validate_form($postdata);
			if($this->validated()){
				$db->where("oc_filecache.fileid", $rec_id);;
				$bool = $db->update($tablename, $modeldata);
				$numRows = $db->getRowCount();
				if($bool && $numRows){
					$this->write_to_log("edit", "true");
					return render_json(
						array(
							'num_rows' =>$numRows,
							'rec_id' =>$rec_id,
						)
					);
				}
				else{
					if($db->getLastError()){
						$page_error = $db->getLastError();
					}
					elseif(!$numRows){
						$page_error = "No record updated";
					}
					$this->write_to_log("edit", "false");
					render_error($page_error);
				}
			}
			else{
				render_error($this->view->page_error);
			}
		}
		return null;
	}
	/**
     * List page records
     * @param $fieldname (filter record by a field) 
     * @param $fieldvalue (filter field value)
     * @return BaseView
     */
	function nclist($fieldname = null , $fieldvalue = null){
		$request = $this->request;
		$db = $this->GetModel();
		$tablename = $this->tablename;
		$fields = array("fileid", 
			"storage", 
			"path", 
			"name", 
			"mimetype", 
			"mimepart");
		$pagination = $this->get_pagination(MAX_RECORD_COUNT); // get current pagination e.g array(page_number, page_limit)
		//search table record
		if(!empty($request->search)){
			$text = trim($request->search); 
			$search_condition = "(
				oc_filecache.fileid LIKE ? OR 
				oc_filecache.storage LIKE ? OR 
				oc_filecache.path LIKE ? OR 
				oc_filecache.path_hash LIKE ? OR 
				oc_filecache.parent LIKE ? OR 
				oc_filecache.name LIKE ? OR 
				oc_filecache.mimetype LIKE ? OR 
				oc_filecache.mimepart LIKE ? OR 
				oc_filecache.size LIKE ? OR 
				oc_filecache.mtime LIKE ? OR 
				oc_filecache.storage_mtime LIKE ? OR 
				oc_filecache.encrypted LIKE ? OR 
				oc_filecache.unencrypted_size LIKE ? OR 
				oc_filecache.etag LIKE ? OR 
				oc_filecache.permissions LIKE ? OR 
				oc_filecache.checksum LIKE ?
			)";
			$search_params = array(
				"%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%","%$text%"
			);
			//setting search conditions
			$db->where($search_condition, $search_params);
			 //template to use when ajax search
			$this->view->search_template = "oc_filecache/search.php";
		}
		if(!empty($request->orderby)){
			$orderby = $request->orderby;
			$ordertype = (!empty($request->ordertype) ? $request->ordertype : ORDER_TYPE);
			$db->orderBy($orderby, $ordertype);
		}
		else{
			$db->orderBy("oc_filecache.fileid", ORDER_TYPE);
		}
		$db->where(" `path` like '%"."4501"."%' ");
		if($fieldname){
			$db->where($fieldname , $fieldvalue); //filter by a single field name
		}
		$tc = $db->withTotalCount();
		$records = $db->get($tablename, $pagination, $fields);
		$records_count = count($records);
		$total_records = intval($tc->totalCount);
		$page_limit = $pagination[1];
		$total_pages = ceil($total_records / $page_limit);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = $records_count;
		$data->total_records = $total_records;
		$data->total_page = $total_pages;
		if($db->getLastError()){
			$this->set_page_error();
		}
		$page_title = $this->view->page_title = "Oc Filecache";
		$this->render_view("oc_filecache/nclist.php", $data); //render the full page
	}
}
