<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("backorder/add");
$can_edit = ACL::is_allowed("backorder/edit");
$can_view = ACL::is_allowed("backorder/view");
$can_delete = ACL::is_allowed("backorder/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Backorder</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("backorder/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Backorder 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('backorder'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('backorder'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('backorder'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="backorder-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-BO_No"> BO_#</th>
                                                <th  <?php echo (get_value('orderby')=='Other_ETA' ? 'class="sortedby td-Other_ETA"' : null); ?>>
                                                    <?php Html :: get_field_order_link('Other_ETA', "ETA"); ?>
                                                </th>
                                                <th  class="td-Dealer"> Dealer</th>
                                                <th  class="td-Customer_PO"> Customer PO</th>
                                                <th  class="td-Tag_Name"> Tag Name</th>
                                                <th  class="td-Value"> Value</th>
                                                <th  class="td-Uppers"> U</th>
                                                <th  class="td-Talls"> T</th>
                                                <th  class="td-Bases"> B</th>
                                                <th  class="td-Vanities"> V</th>
                                                <th  class="td-Accessories"> Acc</th>
                                                <th  class="td-Door_Style"> Door Style</th>
                                                <th  class="td-Wood"> Wood</th>
                                                <th  class="td-Colour"> Colour</th>
                                                <th  class="td-Status"> Status</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['BO_ID']) ? urlencode($data['BO_ID']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <?php if($can_view){ ?>
                                                    <a class="btn btn-sm btn-success has-tooltip page-modal" title="View Record" href="<?php print_link("backorder/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip page-modal" title="Edit This Record" href="<?php print_link("backorder/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                                <td class="td-BO_No"> <?php echo $data['BO_No']; ?></td>
                                                <td class="td-Other_ETA">
                                                    <span <?php if($can_edit){ ?> data-flatpickr="{ enableTime: false, minDate: '', maxDate: ''}" 
                                                        data-value="<?php echo $data['Other_ETA']; ?>" 
                                                        data-pk="<?php echo $data['BO_ID'] ?>" 
                                                        data-url="<?php print_link("backorder/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Other_ETA" 
                                                        data-title="Enter ETA of Parts" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="flatdatetimepicker" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Other_ETA']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Dealer"> <?php echo $data['Dealer']; ?></td>
                                                <td class="td-Customer_PO"> <?php echo $data['Customer_PO']; ?></td>
                                                <td class="td-Tag_Name"> <?php echo $data['Tag_Name']; ?></td>
                                                <td class="td-Value"> <?php echo $data['Value']; ?></td>
                                                <td class="td-Uppers"> <?php echo $data['Uppers']; ?></td>
                                                <td class="td-Talls"> <?php echo $data['Talls']; ?></td>
                                                <td class="td-Bases"> <?php echo $data['Bases']; ?></td>
                                                <td class="td-Vanities"> <?php echo $data['Vanities']; ?></td>
                                                <td class="td-Accessories"> <?php echo $data['Accessories']; ?></td>
                                                <td class="td-Door_Style"> <?php echo $data['Door_Style']; ?></td>
                                                <td class="td-Wood"> <?php echo $data['Wood']; ?></td>
                                                <td class="td-Colour"> <?php echo $data['Colour']; ?></td>
                                                <td class="td-Status">
                                                    <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $Status); ?>' 
                                                        data-value="<?php echo $data['Status']; ?>" 
                                                        data-pk="<?php echo $data['BO_ID'] ?>" 
                                                        data-url="<?php print_link("backorder/editfield/" . urlencode($data['Job_Number'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Status']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
