<?php 
//check if current user role is allowed access to the pages
$can_add = ACL::is_allowed("maintenance_checklist/add");
$can_edit = ACL::is_allowed("maintenance_checklist/edit");
$can_view = ACL::is_allowed("maintenance_checklist/view");
$can_delete = ACL::is_allowed("maintenance_checklist/delete");
?>
<?php
$comp_model = new SharedController;
$page_element_id = "list-page-" . random_str();
$current_page = $this->set_current_page_link();
$csrf_token = Csrf::$token;
//Page Data From Controller
$view_data = $this->view_data;
$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = $this->route->field_name;
$field_value = $this->route->field_value;
$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;
?>
<section class="page" id="<?php echo $page_element_id; ?>" data-page-type="list"  data-display-type="table" data-page-url="<?php print_link($current_page); ?>">
    <?php
    if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3">
        <div class="container-fluid">
            <div class="row ">
                <div class="col ">
                    <h4 class="record-title">Maintenance Checklist</h4>
                </div>
                <div class="col-sm-3 ">
                    <?php if($can_add){ ?>
                    <a  class="btn btn btn-primary my-1" href="<?php print_link("maintenance_checklist/add") ?>">
                        <i class="icon dripicons-plus"></i>                             
                        Add New Maintenance Checklist 
                    </a>
                    <?php } ?>
                </div>
                <div class="col-sm-4 ">
                    <form  class="search" action="<?php print_link('maintenance_checklist'); ?>" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="icon dripicons-search"></i></button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <!-- Page bread crumbs components-->
                            <?php
                            if(!empty($field_name) || !empty($_GET['search'])){
                            ?>
                            <hr class="sm d-block d-sm-none" />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <?php
                                    if(!empty($field_name)){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('maintenance_checklist'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <?php echo (get_value("tag") ? get_value("tag")  :  make_readable($field_name)); ?>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold">
                                        <?php echo (get_value("label") ? get_value("label")  :  make_readable(urldecode($field_value))); ?>
                                    </li>
                                    <?php 
                                    }   
                                    ?>
                                    <?php
                                    if(get_value("search")){
                                    ?>
                                    <li class="breadcrumb-item">
                                        <a class="text-decoration-none" href="<?php print_link('maintenance_checklist'); ?>">
                                            <i class="icon dripicons-arrow-thin-left"></i>
                                        </a>
                                    </li>
                                    <li class="breadcrumb-item text-capitalize">
                                        Search
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize font-weight-bold"><?php echo get_value("search"); ?></li>
                                    <?php
                                    }
                                    ?>
                                </ul>
                            </nav>
                            <!--End of Page bread crumbs components-->
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        }
        ?>
        <div  class="">
            <div class="container-fluid">
                <div class="row ">
                    <div class="col-md-12 comp-grid">
                        <?php $this :: display_page_errors(); ?>
                        <div  class=" animated fadeIn page-content">
                            <div id="maintenance_checklist-list-records">
                                <div id="page-report-body" class="table-responsive">
                                    <table class="table  table-striped table-sm text-left">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-btn"></th>
                                                <th  class="td-PK_Maintenance_Checklist_id"> Checklist ID</th>
                                                <th  class="td-Title"> Title</th>
                                                <th  class="td-Description"> Description</th>
                                                <th  class="td-Assign_To"> Assign To</th>
                                                <th  class="td-Time_Monday"> Time Monday</th>
                                                <th  class="td-Time_Tuesday"> Time Tuesday</th>
                                                <th  class="td-Time_Wednesday"> Time Wednesday</th>
                                                <th  class="td-Time_Thursday"> Time Thursday</th>
                                                <th  class="td-Time_Friday"> Time Friday</th>
                                                <th  class="td-Status"> Status</th>
                                                <th  class="td-Manager"> Manager</th>
                                            </tr>
                                        </thead>
                                        <?php
                                        if(!empty($records)){
                                        ?>
                                        <tbody class="page-data" id="page-data-<?php echo $page_element_id; ?>">
                                            <!--record-->
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $rec_id = (!empty($data['PK_Maintenance_Checklist_id']) ? urlencode($data['PK_Maintenance_Checklist_id']) : null);
                                            $counter++;
                                            ?>
                                            <tr>
                                                <th class="td-btn">
                                                    <?php if($can_view){ ?>
                                                    <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link("maintenance_checklist/view/$rec_id"); ?>">
                                                        <i class="icon dripicons-preview"></i> View
                                                    </a>
                                                    <?php } ?>
                                                    <?php if($can_edit){ ?>
                                                    <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link("maintenance_checklist/edit/$rec_id"); ?>">
                                                        <i class="icon dripicons-document-edit"></i> Edit
                                                    </a>
                                                    <?php } ?>
                                                </th>
                                                <td class="td-PK_Maintenance_Checklist_id"><a href="<?php print_link("maintenance_checklist/view/$data[PK_Maintenance_Checklist_id]") ?>"><?php echo $data['PK_Maintenance_Checklist_id']; ?></a></td>
                                                <td class="td-Title">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Title']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Title" 
                                                        data-title="Enter Title" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="popover" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Title']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Description">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Description']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Description" 
                                                        data-title="Enter Description" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Description']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Assign_To">
                                                    <span <?php if($can_edit){ ?> data-source='<?php print_link('api/json/maintenance_checklist_Assign_To_option_list'); ?>' 
                                                        data-value="<?php echo $data['Assign_To']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Assign_To" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Assign_To']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Time_Monday">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Time_Monday']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Time_Monday" 
                                                        data-title="Enter Time Monday" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="time" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Time_Monday']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Time_Tuesday">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Time_Tuesday']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Time_Tuesday" 
                                                        data-title="Enter Time Tuesday" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="time" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Time_Tuesday']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Time_Wednesday">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Time_Wednesday']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Time_Wednesday" 
                                                        data-title="Enter Time Wednesday" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="time" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Time_Wednesday']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Time_Thursday">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Time_Thursday']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Time_Thursday" 
                                                        data-title="Enter Time Thursday" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="time" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Time_Thursday']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Time_Friday">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Time_Friday']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Time_Friday" 
                                                        data-title="Enter Time Friday" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="time" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Time_Friday']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Status">
                                                    <span <?php if($can_edit){ ?> data-source='<?php echo json_encode_quote(Menu :: $Status2); ?>' 
                                                        data-value="<?php echo $data['Status']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Status" 
                                                        data-title="Select a value ..." 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="select" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Status']; ?> 
                                                    </span>
                                                </td>
                                                <td class="td-Manager">
                                                    <span <?php if($can_edit){ ?> data-value="<?php echo $data['Manager']; ?>" 
                                                        data-pk="<?php echo $data['PK_Maintenance_Checklist_id'] ?>" 
                                                        data-url="<?php print_link("maintenance_checklist/editfield/" . urlencode($data['PK_Maintenance_Checklist_id'])); ?>" 
                                                        data-name="Manager" 
                                                        data-title="Enter Manager" 
                                                        data-placement="left" 
                                                        data-toggle="click" 
                                                        data-type="text" 
                                                        data-mode="inline" 
                                                        data-showbuttons="left" 
                                                        class="is-editable" <?php } ?>>
                                                        <?php echo $data['Manager']; ?> 
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php 
                                            }
                                            ?>
                                            <!--endrecord-->
                                        </tbody>
                                        <tbody class="search-data" id="search-data-<?php echo $page_element_id; ?>"></tbody>
                                        <?php
                                        }
                                        ?>
                                    </table>
                                    <?php 
                                    if(empty($records)){
                                    ?>
                                    <h4 class="bg-light text-center border-top text-muted animated bounce  p-3">
                                        <i class="icon dripicons-wrong"></i> No record found
                                    </h4>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <?php
                                if( $show_footer && !empty($records)){
                                ?>
                                <div class=" border-top mt-2">
                                    <div class="row justify-content-center">    
                                        <div class="col-md-auto justify-content-center">    
                                            <div class="p-3 d-flex justify-content-between">    
                                            </div>
                                        </div>
                                        <div class="col">   
                                            <?php
                                            if($show_pagination == true){
                                            $pager = new Pagination($total_records, $record_count);
                                            $pager->route = $this->route;
                                            $pager->show_page_count = true;
                                            $pager->show_record_count = true;
                                            $pager->show_page_limit =true;
                                            $pager->limit_count = $this->limit_count;
                                            $pager->show_page_number_list = true;
                                            $pager->pager_link_range=5;
                                            $pager->render();
                                            }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
