<?php 
/**
 * Rl_5_Rgalist Page Controller
 * @category  Controller
 */
class Rl_5_RgalistController extends SecureController{
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
		$db = $this->GetModel();
		$fields = array('RGANum', 	'Dealer', 	'TagName', 	'RGAEntry', 	'RGAIssuer', 	'Value', 	'Comments', 	'OriginalOrder', 	'NewJobNum', 	'PickUpDate');
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		if(!empty($this->search)){
			$text = $this->search;
			$db->orWhere('RGANum',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('RGAEntry',"%$text%",'LIKE');
			$db->orWhere('RGAIssuer',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('RecdRFQ',"%$text%",'LIKE');
			$db->orWhere('ExtraLeadTime',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('SentToRGAE',"%$text%",'LIKE');
			$db->orWhere('SentToDealer',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('Originator',"%$text%",'LIKE');
			$db->orWhere('NumRevisions',"%$text%",'LIKE');
			$db->orWhere('OriginalOrder',"%$text%",'LIKE');
			$db->orWhere('NewJobNum',"%$text%",'LIKE');
			$db->orWhere('PickUpDate',"%$text%",'LIKE');
			$db->orWhere('GoodsRecd',"%$text%",'LIKE');
			$db->orWhere('Location',"%$text%",'LIKE');
			$db->orWhere('PiecesRecd',"%$text%",'LIKE');
			$db->orWhere('WhoRecd',"%$text%",'LIKE');
			$db->orWhere('ItemsToBeRetd',"%$text%",'LIKE');
			$db->orWhere('PiecesToBeRetd',"%$text%",'LIKE');
			$db->orWhere('DateRetd',"%$text%",'LIKE');
			$db->orWhere('PropRetDate',"%$text%",'LIKE');
			$db->orWhere('status',"%$text%",'LIKE');
			$db->orWhere('completed',"%$text%",'LIKE');
		}
		if(!empty($this->orderby)){ // when order by request fields (from $_GET param)
			$db->orderBy($this->orderby,$this->ordertype);
		}
		else{
			$db->orderBy('RGANum', ORDER_TYPE);
		}
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('rl_5_rgalist', $limit, $fields);
		$data = new stdClass;
		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="RGA List";
		$this->view->render('rl_5_rgalist/list.php' , $data ,'main_layout.php');
	}
	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
		$db = $this->GetModel();
		$fields = array( 'RGANum', 	'Dealer', 	'TagName', 	'RGAEntry', 	'RGAIssuer', 	'SalesRep', 	'RecdRFQ', 	'ExtraLeadTime', 	'Value', 	'SentToRGAE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions', 	'OriginalOrder', 	'NewJobNum', 	'PickUpDate', 	'GoodsRecd', 	'Location', 	'PiecesRecd', 	'WhoRecd', 	'ItemsToBeRetd', 	'PiecesToBeRetd', 	'DateRetd', 	'PropRetDate', 	'status', 	'completed' );
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('RGANum' , $rec_id);
		}
		$record = $db->getOne( 'rl_5_rgalist', $fields );
		if(!empty($record)){
			$this->view->page_title ="View  RGA";
			$this->view->render('rl_5_rgalist/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('rl_5_rgalist/view.php' , $record , 'main_layout.php');
		}
	}
	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'Dealer' => 'required',
				'TagName' => 'required',
				'RGAEntry' => 'required',
				'RGAIssuer' => 'required',
				'SalesRep' => 'required',
				'RecdRFQ' => 'required',
				'ExtraLeadTime' => 'required',
				'Value' => 'required|numeric',
				'SentToRGAE' => 'required',
				'SentToDealer' => 'required',
				'Comments' => 'required',
				'Originator' => 'required',
				'NumRevisions' => 'required|numeric',
				'OriginalOrder' => 'required',
				'NewJobNum' => 'required',
				'PickUpDate' => 'required',
				'GoodsRecd' => 'required',
				'Location' => 'required',
				'PiecesRecd' => 'required|numeric',
				'WhoRecd' => 'required',
				'ItemsToBeRetd' => 'required',
				'PiecesToBeRetd' => 'required|numeric',
				'DateRetd' => 'required',
				'PropRetDate' => 'required',
				'status' => 'required|numeric',
				'completed' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				$rec_id = $db->insert( 'rl_5_rgalist' , $modeldata );
				if(!empty($rec_id)){
					set_flash_msg('','');
					redirect_to_page("rl_5_rgalist");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New RGA";
		$this->view->render('rl_5_rgalist/add.php' ,null,'main_layout.php');
	}
	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			$rules_array = array(
				'Dealer' => 'required',
				'TagName' => 'required',
				'RGAEntry' => 'required',
				'RGAIssuer' => 'required',
				'SalesRep' => 'required',
				'RecdRFQ' => 'required',
				'ExtraLeadTime' => 'required',
				'Value' => 'required|numeric',
				'SentToRGAE' => 'required',
				'SentToDealer' => 'required',
				'Comments' => 'required',
				'Originator' => 'required',
				'NumRevisions' => 'required|numeric',
				'OriginalOrder' => 'required',
				'NewJobNum' => 'required',
				'PickUpDate' => 'required',
				'GoodsRecd' => 'required',
				'Location' => 'required',
				'PiecesRecd' => 'required|numeric',
				'WhoRecd' => 'required',
				'ItemsToBeRetd' => 'required',
				'PiecesToBeRetd' => 'required|numeric',
				'DateRetd' => 'required',
				'PropRetDate' => 'required',
				'status' => 'required|numeric',
				'completed' => 'required',
			);
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}
			if(empty($this->view->page_error)){
				$db->where('RGANum' , $rec_id);
				$bool = $db->update('rl_5_rgalist',$modeldata);
				if($bool){
					set_flash_msg('','');
					redirect_to_page("rl_5_rgalist");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}
		$fields = array('RGANum','Dealer','TagName','RGAEntry','RGAIssuer','SalesRep','RecdRFQ','ExtraLeadTime','Value','SentToRGAE','SentToDealer','Comments','Originator','NumRevisions','OriginalOrder','NewJobNum','PickUpDate','GoodsRecd','Location','PiecesRecd','WhoRecd','ItemsToBeRetd','PiecesToBeRetd','DateRetd','PropRetDate','status','completed');
		$db->where('RGANum' , $rec_id);
		$data = $db->getOne('rl_5_rgalist',$fields);
		$this->view->page_title ="Edit  RGA";
		if(!empty($data)){
			$this->view->render('rl_5_rgalist/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			$this->view->render('rl_5_rgalist/edit.php' , $data , 'main_layout.php');
		}
	}
}
