<?php 
defined('ROOT') OR exit('No direct script access allowed');

/**
* Application Base Controller 
* Controllers Which Do Not Need Authentication Inherit From This Class
*/
class BaseController{
	
	public $view=null;
	public $db=null;
	public $page_num=1;
	public $limit_start=1;
	public $limit_count=MAX_RECORD_COUNT;
	public $orderby=null;
	public $ordertype=ORDER_TYPE;
	public $search=null;
	
	public $file_upload_settings = array();
	
	function __construct(){
		$this->view=new BaseView;
		$q=$_GET;
		if(!empty($q)){
			foreach($q as $obj=>$val){
				$this->$obj=$val;
			}	
		}
		if(empty($this->limit_start)){
			$this->limit_start=1;
		}
		$this->page_num=$this->limit_start;
		$this->limit_start=($this->limit_start-1) * $this->limit_count;
		
		
		
	}
	
	function GetModel($arg=null){
		//Initialse New Database Connection
		return new PDODb(DB_TYPE, DB_HOST , DB_USERNAME, DB_PASSWORD, DB_NAME, DB_PORT , DB_CHARSET);
	}
	
	function delete_record_files($files, $field){
		foreach($files as $file_path){
			$comma_paths = explode( ',', $file_path[$field] );
			foreach($comma_paths as $file_url){
				try{
					$file_dir_path = str_ireplace( SITE_ADDR , "" , $file_url ) ;
					@unlink($file_dir_path);
				}
				catch(Exception $e) {
				  // error_log('Message: ' .$e->getMessage());
				}
			}
		}
	}
	
	function get_uploaded_file_paths($fieldname){
		$uploaded_files = "";
		if(!empty($_FILES[$fieldname])){
			
			$uploader = new Uploader;
			$upload_settings = $this->file_upload_settings[$fieldname];
			$upload_data = $uploader->upload($_FILES[$fieldname], $upload_settings );
			if($upload_data['isComplete']){
				$arr_files = $upload_data['data']['files'];
				if(!empty($arr_files)){
					if(!empty($upload_settings['returnfullpath'])){
						$arr_files = array_map( "set_url", $arr_files ); // set files with complete url of the website
					}
					$uploaded_files = implode("," , $arr_files);
				}
			}
			if($upload_data['hasErrors']){
				$errors = $upload_data['errors'];
				foreach($errors as $key=>$val){
					$this->view->page_error[] = "$key : $val[$key]";
				}
			}
		}
		return $uploaded_files;
	}
	
	function get_uploaded_file_data($fieldname){
		if(!empty($_FILES[$fieldname])){
			
			$name = $_FILES[$fieldname]['name'];
			$extension = strtolower(substr($name, strpos($name, '.') + 1));
			$tmp_name = $_FILES[$fieldname]['tmp_name'];
			$type = $_FILES[$fieldname]['type'];
			$size = $_FILES[$fieldname]['size'];
			
			return file_get_contents($tmp_name);
		}
		return null;
	}
	
	
	function validate_form($postdata){
		//remove unwanted html characters to prevent xss attack
		$modeldata = GUMP::filter_input($postdata, $this->sanitize_array); 
		
		$is_valid = GUMP::is_valid($modeldata, $this->rules_array);
		if( $is_valid !== true) {
			if(is_array($is_valid)){
				foreach($is_valid as  $error_msg){
					$this->view->page_error[] = $error_msg;
				}
			}
			else{
				$this->view->page_error[] = $is_valid;
			}
		}
		return $modeldata;
	}
	
	/**
	 * Set Current Page Start and Page Count
	 * $page_count Set Max Record to retrive per page
	 * $fieldvalue Table Field Value 
	 * @return array(limit_start,limit_count)
	 */
	function get_page_limit($page_count = MAX_RECORD_COUNT){
		
		if(!empty($_GET['limit_count'])){ //Get page limit from query string request if available
		
			 /*Set limit to high number to get all records. starting from the current position */
			 
			if($_GET['limit_count'] == -1){
				$this->limit_count=1000000000;
			}
			else{
				$this->limit_count=$_GET['limit_count'];
			}
		}
		else{
			$this->limit_count=$page_count;
			//$_GET['limit_count']=$page_count;
		}
		
		return array($this->limit_start,$this->limit_count);
	}
}

/**
* Controllers Which Needs Authentication And Access Control Can Extends To This Class
*/
class SecureController extends BaseController{
	function __construct(){
		parent::__construct();
		
		// Page actions which do not require authentication.
		$exclude_pages = array();
		
		$url = Router :: $page_url;
		$url = str_ireplace('/index','/list',$url);
		
		if(!empty($url)){
			$url_segment =$url_segment = explode("/" , rtrim($url , "/")) ;
			
			$controller = strtolower(!empty($url_segment[0]) ? $url_segment[0] : null);
			$action = strtolower((!empty($url_segment[1]) ? $url_segment[1] : 'list'));
			
			$page = "$controller/$action";
			
			if( !in_array($page , $exclude_pages )){
				authenticate_user(); // Authenticate user And Authorise User
			}
		}
		
	}
}