<?php 

/**
 * Jl_7_Joblist_Deleted Page Controller
 * @category  Controller
 */
class Jl_7_Joblist_DeletedController extends SecureController{
	
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
	
		$db = $this->GetModel();
		
		$fields = array('JobNum', 	'Artisan', 	'Dealer', 	'CustomerNum', 	'TagName', 	'OrderEntry', 	'SalesRep', 	'RecdOrder', 	'StdLeadTime', 	'ReqDate', 	'Value', 	'SentToOE', 	'SentToDealer', 	'Confirmed', 	'SentToPlant', 	'Inv', 	'Comments', 	'TimeStamp', 	'RSO', 	'Uppers', 	'Talls', 	'Bases', 	'Vanities', 	'Accessories', 	'Wood', 	'Colour', 	'DoorVendor', 	'DoorETA', 	'OtherETA', 	'Priority', 	'Creator', 	'DoorStyle', 	'Conf_Rec', 	'NJobNum', 	'DateShipped', 	'BackOrders', 	'BackOrdersShipped', 	'propshipdate', 	'shipcomments', 	'shipdetails', 	'DealerRoute', 	'OrgJobNum', 	'changed_by', 	'updated', 	'pk_joblist_deleted_id');
		
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		
		if(!empty($this->search)){
			$text = $this->search;
			
			$db->orWhere('JobNum',"%$text%",'LIKE');
			$db->orWhere('Artisan',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('CustomerNum',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('OrderEntry',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('RecdOrder',"%$text%",'LIKE');
			$db->orWhere('StdLeadTime',"%$text%",'LIKE');
			$db->orWhere('ReqDate',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('SentToOE',"%$text%",'LIKE');
			$db->orWhere('SentToDealer',"%$text%",'LIKE');
			$db->orWhere('Confirmed',"%$text%",'LIKE');
			$db->orWhere('SentToPlant',"%$text%",'LIKE');
			$db->orWhere('Inv',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('RSO',"%$text%",'LIKE');
			$db->orWhere('Uppers',"%$text%",'LIKE');
			$db->orWhere('Talls',"%$text%",'LIKE');
			$db->orWhere('Bases',"%$text%",'LIKE');
			$db->orWhere('Vanities',"%$text%",'LIKE');
			$db->orWhere('Accessories',"%$text%",'LIKE');
			$db->orWhere('Wood',"%$text%",'LIKE');
			$db->orWhere('Colour',"%$text%",'LIKE');
			$db->orWhere('DoorVendor',"%$text%",'LIKE');
			$db->orWhere('DoorETA',"%$text%",'LIKE');
			$db->orWhere('OtherETA',"%$text%",'LIKE');
			$db->orWhere('Priority',"%$text%",'LIKE');
			$db->orWhere('Creator',"%$text%",'LIKE');
			$db->orWhere('DoorStyle',"%$text%",'LIKE');
			$db->orWhere('Conf_Rec',"%$text%",'LIKE');
			$db->orWhere('NJobNum',"%$text%",'LIKE');
			$db->orWhere('DateShipped',"%$text%",'LIKE');
			$db->orWhere('BackOrders',"%$text%",'LIKE');
			$db->orWhere('BackOrdersShipped',"%$text%",'LIKE');
			$db->orWhere('propshipdate',"%$text%",'LIKE');
			$db->orWhere('shipcomments',"%$text%",'LIKE');
			$db->orWhere('shipdetails',"%$text%",'LIKE');
			$db->orWhere('DealerRoute',"%$text%",'LIKE');
			$db->orWhere('OrgJobNum',"%$text%",'LIKE');
			$db->orWhere('changed_by',"%$text%",'LIKE');
			$db->orWhere('updated',"%$text%",'LIKE');
			$db->orWhere('pk_joblist_deleted_id',"%$text%",'LIKE');
		}

		
		if(!empty($this->orderby)){
			$db->orderBy($this->orderby,$this->ordertype);
		}
		
		
		
		
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('jl_7_joblist_deleted', $limit, $fields);
		
		$data = new stdClass;

		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		
		
		
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Jl 7 Joblist Deleted";
		$this->view->render('jl_7_joblist_deleted/list.php' , $data ,'main_layout.php');
		
	}
	
	
	/**
     * Load csv|json data
     * @return data
     */
	function import_data(){
		if(!empty($_FILES['file'])){
			$finfo = pathinfo($_FILES['file']['name']);
			$ext = strtolower($finfo['extension']);
			if(!in_array($ext , array('csv','json'))){
				set_flash_msg("File format not supported",'danger');
			}
			else{
				
			$file_path = $_FILES['file']['tmp_name'];

				if(!empty($file_path)){
					$db = $this->GetModel();
					if($ext == 'csv'){
						$options = array('table' => 'jl_7_joblist_deleted', 'fields' => '', 'delimiter' => ',', 'quote' => '"');
						$data = $db->loadCsvData( $file_path , $options , false );
					}
					else{
						$data = $db->loadJsonData( $file_path, 'jl_7_joblist_deleted' , false );
					}
					if($db->getLastError()){
						set_flash_msg($db->getLastError(),'danger');
					}
					else{
						set_flash_msg("Data imported successfully",'success');
					}
				}
				else{
					set_flash_msg("Error uploading file",'success');
				}
			}
		}
		else{
			set_flash_msg("No file selected for upload",'warning');
		}
		
		$list_page = (!empty($_POST['redirect']) ? $_POST['redirect'] : 'jl_7_joblist_deleted/list');
		redirect_to_page($list_page);
	}
	

	


	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
	
		$db = $this->GetModel();
		
		
		$fields = array( 'JobNum', 	'Artisan', 	'Dealer', 	'CustomerNum', 	'TagName', 	'OrderEntry', 	'SalesRep', 	'RecdOrder', 	'StdLeadTime', 	'ReqDate', 	'Value', 	'SentToOE', 	'SentToDealer', 	'Confirmed', 	'SentToPlant', 	'Inv', 	'Comments', 	'TimeStamp', 	'RSO', 	'Uppers', 	'Talls', 	'Bases', 	'Vanities', 	'Accessories', 	'Wood', 	'Colour', 	'DoorVendor', 	'DoorETA', 	'OtherETA', 	'Priority', 	'Creator', 	'DoorStyle', 	'Conf_Rec', 	'NJobNum', 	'DateShipped', 	'BackOrders', 	'BackOrdersShipped', 	'propshipdate', 	'shipcomments', 	'shipdetails', 	'DealerRoute', 	'OrgJobNum', 	'changed_by', 	'updated', 	'pk_joblist_deleted_id' );
		
		
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('pk_joblist_deleted_id' , $rec_id);
		}
		
		  
		$record = $db->getOne( 'jl_7_joblist_deleted', $fields );

		if(!empty($record)){
			
			
			
			$this->view->page_title ="View  Jl 7 Joblist Deleted";
			$this->view->render('jl_7_joblist_deleted/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('jl_7_joblist_deleted/view.php' , $record , 'main_layout.php');
		}
	}


	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			
			
			
			$rules_array = array(
				
				'JobNum' => 'required',
				'Artisan' => 'required',
				'Dealer' => 'required',
				'CustomerNum' => 'required',
				'TagName' => 'required',
				'OrderEntry' => 'required',
				'SalesRep' => 'required',
				'RecdOrder' => 'required',
				'StdLeadTime' => 'required',
				'ReqDate' => 'required',
				'Value' => 'required|numeric',
				'SentToOE' => 'required',
				'SentToDealer' => 'required',
				'Confirmed' => 'required',
				'SentToPlant' => 'required',
				'Inv' => 'required',
				'Comments' => 'required',
				'RSO' => 'required',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Wood' => 'required',
				'Colour' => 'required',
				'DoorVendor' => 'required',
				'DoorETA' => 'required',
				'OtherETA' => 'required',
				'Priority' => 'required',
				'Creator' => 'required',
				'DoorStyle' => 'required',
				'Conf_Rec' => 'required',
				'NJobNum' => 'required',
				'DateShipped' => 'required',
				'BackOrders' => 'required',
				'BackOrdersShipped' => 'required',
				'propshipdate' => 'required',
				'shipcomments' => 'required',
				'shipdetails' => 'required',
				'DealerRoute' => 'required',
				'OrgJobNum' => 'required',
				'changed_by' => 'required',
				'updated' => 'required',
			);
			
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}

			
			
			
			
			
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				
				$rec_id = $db->insert( 'jl_7_joblist_deleted' , $modeldata );
				if(!empty($rec_id)){
					
					
					set_flash_msg("Record added successfully",'success');
					redirect_to_page("jl_7_joblist_deleted");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Jl 7 Joblist Deleted";
		$this->view->render('jl_7_joblist_deleted/add.php' ,null,'main_layout.php');
	}


	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			
			
			
			
			$rules_array = array(
				
				'JobNum' => 'required',
				'Artisan' => 'required',
				'Dealer' => 'required',
				'CustomerNum' => 'required',
				'TagName' => 'required',
				'OrderEntry' => 'required',
				'SalesRep' => 'required',
				'RecdOrder' => 'required',
				'StdLeadTime' => 'required',
				'ReqDate' => 'required',
				'Value' => 'required|numeric',
				'SentToOE' => 'required',
				'SentToDealer' => 'required',
				'Confirmed' => 'required',
				'SentToPlant' => 'required',
				'Inv' => 'required',
				'Comments' => 'required',
				'RSO' => 'required',
				'Uppers' => 'required|numeric',
				'Talls' => 'required|numeric',
				'Bases' => 'required|numeric',
				'Vanities' => 'required|numeric',
				'Accessories' => 'required|numeric',
				'Wood' => 'required',
				'Colour' => 'required',
				'DoorVendor' => 'required',
				'DoorETA' => 'required',
				'OtherETA' => 'required',
				'Priority' => 'required',
				'Creator' => 'required',
				'DoorStyle' => 'required',
				'Conf_Rec' => 'required',
				'NJobNum' => 'required',
				'DateShipped' => 'required',
				'BackOrders' => 'required',
				'BackOrdersShipped' => 'required',
				'propshipdate' => 'required',
				'shipcomments' => 'required',
				'shipdetails' => 'required',
				'DealerRoute' => 'required',
				'OrgJobNum' => 'required',
				'changed_by' => 'required',
				'updated' => 'required',
			);
			
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}

			
			 
			
			
			if(empty($this->view->page_error)){
				
				$db->where('pk_joblist_deleted_id' , $rec_id);
				
				$bool = $db->update('jl_7_joblist_deleted',$modeldata);
				if($bool){
					
					set_flash_msg("Record updated successfully",'success');
					
					redirect_to_page("jl_7_joblist_deleted");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}

		$fields = array('JobNum','Artisan','Dealer','CustomerNum','TagName','OrderEntry','SalesRep','RecdOrder','StdLeadTime','ReqDate','Value','SentToOE','SentToDealer','Confirmed','SentToPlant','Inv','Comments','RSO','Uppers','Talls','Bases','Vanities','Accessories','Wood','Colour','DoorVendor','DoorETA','OtherETA','Priority','Creator','DoorStyle','Conf_Rec','NJobNum','DateShipped','BackOrders','BackOrdersShipped','propshipdate','shipcomments','shipdetails','DealerRoute','OrgJobNum','changed_by','updated','pk_joblist_deleted_id');
		$db->where('pk_joblist_deleted_id' , $rec_id);
		$data = $db->getOne('jl_7_joblist_deleted',$fields);
		
		$this->view->page_title ="Edit  Jl 7 Joblist Deleted";
		if(!empty($data)){
			$this->view->render('jl_7_joblist_deleted/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			
			$this->view->render('jl_7_joblist_deleted/edit.php' , $data , 'main_layout.php');
		}
	}
	


	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		
		$db = $this->GetModel();
		
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('pk_joblist_deleted_id' , $rec_id,"=",'OR');
		}
		
		
		$bool = $db->delete( 'jl_7_joblist_deleted' );
		
		if($bool){
			 
			set_flash_msg("Record deleted successfully",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}

		redirect_to_page("jl_7_joblist_deleted");
	}


}
