<?php 

/**
 * Ql_5_Quotelist Page Controller
 * @category  Controller
 */
class Ql_5_QuotelistController extends SecureController{
	
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
	
		$db = $this->GetModel();
		
		$fields = array('QuoteNum', 	'Dealer', 	'TagName', 	'QuoteEntry', 	'Quoter', 	'SalesRep', 	'RecdRFQ', 	'ExtraLeadTime', 	'Value', 	'SentToQE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions');
		
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		
		if(!empty($this->search)){
			$text = $this->search;
			
			$db->orWhere('QuoteNum',"%$text%",'LIKE');
			$db->orWhere('Dealer',"%$text%",'LIKE');
			$db->orWhere('TagName',"%$text%",'LIKE');
			$db->orWhere('QuoteEntry',"%$text%",'LIKE');
			$db->orWhere('Quoter',"%$text%",'LIKE');
			$db->orWhere('SalesRep',"%$text%",'LIKE');
			$db->orWhere('RecdRFQ',"%$text%",'LIKE');
			$db->orWhere('ExtraLeadTime',"%$text%",'LIKE');
			$db->orWhere('Value',"%$text%",'LIKE');
			$db->orWhere('SentToQE',"%$text%",'LIKE');
			$db->orWhere('SentToDealer',"%$text%",'LIKE');
			$db->orWhere('Comments',"%$text%",'LIKE');
			$db->orWhere('TimeStamp',"%$text%",'LIKE');
			$db->orWhere('Originator',"%$text%",'LIKE');
			$db->orWhere('NumRevisions',"%$text%",'LIKE');
		}

		
		if(!empty($this->orderby)){
			$db->orderBy($this->orderby,$this->ordertype);
		}
		
		
		
		
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('ql_5_quotelist', $limit, $fields);
		
		$data = new stdClass;

		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		
		
		
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Ql 5 Quotelist";
		$this->view->render('ql_5_quotelist/list.php' , $data ,'main_layout.php');
		
	}
	
	
	/**
     * Load csv|json data
     * @return data
     */
	function import_data(){
		if(!empty($_FILES['file'])){
			$finfo = pathinfo($_FILES['file']['name']);
			$ext = strtolower($finfo['extension']);
			if(!in_array($ext , array('csv','json'))){
				set_flash_msg("File format not supported",'danger');
			}
			else{
				
			$file_path = $_FILES['file']['tmp_name'];

				if(!empty($file_path)){
					$db = $this->GetModel();
					if($ext == 'csv'){
						$options = array('table' => 'ql_5_quotelist', 'fields' => '', 'delimiter' => ',', 'quote' => '"');
						$data = $db->loadCsvData( $file_path , $options , false );
					}
					else{
						$data = $db->loadJsonData( $file_path, 'ql_5_quotelist' , false );
					}
					if($db->getLastError()){
						set_flash_msg($db->getLastError(),'danger');
					}
					else{
						set_flash_msg("Data imported successfully",'success');
					}
				}
				else{
					set_flash_msg("Error uploading file",'success');
				}
			}
		}
		else{
			set_flash_msg("No file selected for upload",'warning');
		}
		
		$list_page = (!empty($_POST['redirect']) ? $_POST['redirect'] : 'ql_5_quotelist/list');
		redirect_to_page($list_page);
	}
	

	


	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
	
		$db = $this->GetModel();
		
		
		$fields = array( 'QuoteNum', 	'Dealer', 	'TagName', 	'QuoteEntry', 	'Quoter', 	'SalesRep', 	'RecdRFQ', 	'ExtraLeadTime', 	'Value', 	'SentToQE', 	'SentToDealer', 	'Comments', 	'TimeStamp', 	'Originator', 	'NumRevisions' );
		
		
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('QuoteNum' , $rec_id);
		}
		
		  
		$record = $db->getOne( 'ql_5_quotelist', $fields );

		if(!empty($record)){
			
			
			
			$this->view->page_title ="View  Ql 5 Quotelist";
			$this->view->render('ql_5_quotelist/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('ql_5_quotelist/view.php' , $record , 'main_layout.php');
		}
	}


	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			
			
			
			$rules_array = array(
				
				'Dealer' => 'required',
				'TagName' => 'required',
				'QuoteEntry' => 'required',
				'Quoter' => 'required',
				'SalesRep' => 'required',
				'RecdRFQ' => 'required',
				'ExtraLeadTime' => 'required',
				'Value' => 'required|numeric',
				'SentToQE' => 'required',
				'SentToDealer' => 'required',
				'Comments' => 'required',
				'Originator' => 'required',
				'NumRevisions' => 'required|numeric',
			);
			
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}

			
			
			
			
			
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				
				$rec_id = $db->insert( 'ql_5_quotelist' , $modeldata );
				if(!empty($rec_id)){
					
					
					set_flash_msg("Record added successfully",'success');
					redirect_to_page("ql_5_quotelist");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Ql 5 Quotelist";
		$this->view->render('ql_5_quotelist/add.php' ,null,'main_layout.php');
	}


	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			
			
			
			
			$rules_array = array(
				
				'Dealer' => 'required',
				'TagName' => 'required',
				'QuoteEntry' => 'required',
				'Quoter' => 'required',
				'SalesRep' => 'required',
				'RecdRFQ' => 'required',
				'ExtraLeadTime' => 'required',
				'Value' => 'required|numeric',
				'SentToQE' => 'required',
				'SentToDealer' => 'required',
				'Comments' => 'required',
				'Originator' => 'required',
				'NumRevisions' => 'required|numeric',
			);
			
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}

			
			 
			
			
			if(empty($this->view->page_error)){
				
				$db->where('QuoteNum' , $rec_id);
				
				$bool = $db->update('ql_5_quotelist',$modeldata);
				if($bool){
					
					set_flash_msg("Record updated successfully",'success');
					
					redirect_to_page("ql_5_quotelist");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}

		$fields = array('QuoteNum','Dealer','TagName','QuoteEntry','Quoter','SalesRep','RecdRFQ','ExtraLeadTime','Value','SentToQE','SentToDealer','Comments','Originator','NumRevisions');
		$db->where('QuoteNum' , $rec_id);
		$data = $db->getOne('ql_5_quotelist',$fields);
		
		$this->view->page_title ="Edit  Ql 5 Quotelist";
		if(!empty($data)){
			$this->view->render('ql_5_quotelist/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			
			$this->view->render('ql_5_quotelist/edit.php' , $data , 'main_layout.php');
		}
	}
	


	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		
		$db = $this->GetModel();
		
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('QuoteNum' , $rec_id,"=",'OR');
		}
		
		
		$bool = $db->delete( 'ql_5_quotelist' );
		
		if($bool){
			 
			set_flash_msg("Record deleted successfully",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}

		redirect_to_page("ql_5_quotelist");
	}


}
