<?php 

/**
 * Sl_2_Job_Prod_Specs Page Controller
 * @category  Controller
 */
class Sl_2_Job_Prod_SpecsController extends SecureController{
	
	/**
     * Load Record Action 
     * $arg1 Field Name
     * $arg2 Field Value 
     * $param $arg1 string
     * $param $arg1 string
     * @return View
     */
	function index($fieldname = null , $fieldvalue = null){
	
		$db = $this->GetModel();
		
		$fields = array('pk_job_prod_specs_id', 	'affectsStation', 	'affectsTime', 	'affectsAmount', 	'changedby', 	'updated');
		
		$limit = $this->get_page_limit(MAX_RECORD_COUNT); // return pagination from BaseModel Class e.g array(5,20)
		
		if(!empty($this->search)){
			$text = $this->search;
			
			$db->orWhere('pk_job_prod_specs_id',"%$text%",'LIKE');
			$db->orWhere('affectsStation',"%$text%",'LIKE');
			$db->orWhere('affectsTime',"%$text%",'LIKE');
			$db->orWhere('affectsAmount',"%$text%",'LIKE');
			$db->orWhere('changedby',"%$text%",'LIKE');
			$db->orWhere('updated',"%$text%",'LIKE');
		}

		
		if(!empty($this->orderby)){
			$db->orderBy($this->orderby,$this->ordertype);
		}
		
		
		
		
		if( !empty($fieldname) ){
			$db->where($fieldname , $fieldvalue);
		}
		//page filter command
		$tc = $db->withTotalCount();
		$records = $db->get('sl_2_job_prod_specs', $limit, $fields);
		
		$data = new stdClass;

		$data->records = $records;
		$data->record_count = count($records);
		$data->total_records = intval($tc->totalCount);
		
		
		
		if($db->getLastError()){
			$this->view->page_error = $db->getLastError();
		}
		$this->view->page_title ="Sl 2 Job Prod Specs";
		$this->view->render('sl_2_job_prod_specs/list.php' , $data ,'main_layout.php');
		
	}
	
	
	/**
     * Load csv|json data
     * @return data
     */
	function import_data(){
		if(!empty($_FILES['file'])){
			$finfo = pathinfo($_FILES['file']['name']);
			$ext = strtolower($finfo['extension']);
			if(!in_array($ext , array('csv','json'))){
				set_flash_msg("File format not supported",'danger');
			}
			else{
				
			$file_path = $_FILES['file']['tmp_name'];

				if(!empty($file_path)){
					$db = $this->GetModel();
					if($ext == 'csv'){
						$options = array('table' => 'sl_2_job_prod_specs', 'fields' => '', 'delimiter' => ',', 'quote' => '"');
						$data = $db->loadCsvData( $file_path , $options , false );
					}
					else{
						$data = $db->loadJsonData( $file_path, 'sl_2_job_prod_specs' , false );
					}
					if($db->getLastError()){
						set_flash_msg($db->getLastError(),'danger');
					}
					else{
						set_flash_msg("Data imported successfully",'success');
					}
				}
				else{
					set_flash_msg("Error uploading file",'success');
				}
			}
		}
		else{
			set_flash_msg("No file selected for upload",'warning');
		}
		
		$list_page = (!empty($_POST['redirect']) ? $_POST['redirect'] : 'sl_2_job_prod_specs/list');
		redirect_to_page($list_page);
	}
	

	


	/**
     * View Record Action 
     * @return View
     */
	function view( $rec_id = null , $value = null){
	
		$db = $this->GetModel();
		
		
		$fields = array( 'pk_job_prod_specs_id', 	'affectsStation', 	'affectsTime', 	'affectsAmount', 	'changedby', 	'updated' );
		
		
		if( !empty($value) ){
			$db->where($rec_id, urldecode($value));
		}
		else{
			$db->where('pk_job_prod_specs_id' , $rec_id);
		}
		
		  
		$record = $db->getOne( 'sl_2_job_prod_specs', $fields );

		if(!empty($record)){
			
			
			
			$this->view->page_title ="View  Sl 2 Job Prod Specs";
			$this->view->render('sl_2_job_prod_specs/view.php' , $record ,'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error = $db->getLastError();
			}
			else{
				$this->view->page_error = "Record not found";
			}
			$this->view->render('sl_2_job_prod_specs/view.php' , $record , 'main_layout.php');
		}
	}


	/**
     * Add New Record Action 
     * If Not $_POST Request, Display Add Record Form View
     * @return View
     */
	function add(){
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			
			
			
			$rules_array = array(
				
				'affectsStation' => 'required',
				'affectsTime' => 'required',
				'affectsAmount' => 'required',
				'changedby' => 'required',
			);
			
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}

			
			
			
			
			
			if( empty($this->view->page_error) ){
				$db = $this->GetModel();
				
				$rec_id = $db->insert( 'sl_2_job_prod_specs' , $modeldata );
				if(!empty($rec_id)){
					
					
					set_flash_msg("Record added successfully",'success');
					redirect_to_page("sl_2_job_prod_specs");
					return;
				}
				else{
					if($db->getLastError()){
						$this->view->page_error[] = $db->getLastError();
					}
					else{
						$this->view->page_error[] = "Error inserting record";
					}
				}
			}
		}
		$this->view->page_title ="Add New Sl 2 Job Prod Specs";
		$this->view->render('sl_2_job_prod_specs/add.php' ,null,'main_layout.php');
	}


	/**
     * Edit Record Action 
     * If Not $_POST Request, Display Edit Record Form View
     * @return View
     */
	function edit($rec_id=null){
		$db = $this->GetModel();
		if(is_post_request()){
			$modeldata = transform_request_data($_POST);
			
			
			
			
			$rules_array = array(
				
				'affectsStation' => 'required',
				'affectsTime' => 'required',
				'affectsAmount' => 'required',
				'changedby' => 'required',
			);
			
			$is_valid = GUMP::is_valid($modeldata, $rules_array);
			
			if( $is_valid !== true) {
				if(is_array($is_valid)){
					foreach($is_valid as  $error_msg){
						$this->view->page_error[] = $error_msg;
					}
				}
				else{
					$this->view->page_error[] = $is_valid;
				}
			}

			
			 
			
			
			if(empty($this->view->page_error)){
				
				$db->where('pk_job_prod_specs_id' , $rec_id);
				
				$bool = $db->update('sl_2_job_prod_specs',$modeldata);
				if($bool){
					
					set_flash_msg("Record updated successfully",'success');
					
					redirect_to_page("sl_2_job_prod_specs");
					return;
				}
				else{
					$this->view->page_error[] = $db->getLastError();
				}
			}
		}

		$fields = array('pk_job_prod_specs_id','affectsStation','affectsTime','affectsAmount','changedby');
		$db->where('pk_job_prod_specs_id' , $rec_id);
		$data = $db->getOne('sl_2_job_prod_specs',$fields);
		
		$this->view->page_title ="Edit  Sl 2 Job Prod Specs";
		if(!empty($data)){
			$this->view->render('sl_2_job_prod_specs/edit.php' , $data, 'main_layout.php');
		}
		else{
			if($db->getLastError()){
				$this->view->page_error[] = $db->getLastError();
			}
			else{
				$this->view->page_error[] = "Record not found";
			}
			
			$this->view->render('sl_2_job_prod_specs/edit.php' , $data , 'main_layout.php');
		}
	}
	


	/**
     * Delete Record Action 
     * @return View
     */
	function delete( $rec_ids = null ){
		
		$db = $this->GetModel();
		
		$arr_id = explode( ',', $rec_ids );
		foreach( $arr_id as $rec_id ){
			$db->where('pk_job_prod_specs_id' , $rec_id,"=",'OR');
		}
		
		
		$bool = $db->delete( 'sl_2_job_prod_specs' );
		
		if($bool){
			 
			set_flash_msg("Record deleted successfully",'success');
		}
		else{
			if($db->getLastError()){
				set_flash_msg($db->getLastError(),'danger');
			}
			else{
				set_flash_msg("Error deleting the record. please make sure that the record exit",'danger');
			}
		}

		redirect_to_page("sl_2_job_prod_specs");
	}


}
