
<?php
$comp_model = new SharedController;

//Page Data From Controller
$view_data = $this->view_data;

$records = $view_data->records;
$record_count = $view_data->record_count;
$total_records = $view_data->total_records;
$field_name = Router :: $field_name;
$field_value = Router :: $field_value;

$view_title = $this->view_title;
$show_header = $this->show_header;
$show_footer = $this->show_footer;
$show_pagination = $this->show_pagination;

?>

<section class="page">
    
    <?php
    if( $show_header == true ){
    ?>
    
    <div  class="bg-light p-3 mb-3">
        <div class="container">
            
            <div class="row ">
                
                <div class="col-sm-4 comp-grid">
                    <h3 class="record-title">Ql 5 Quotelist</h3>
                    
                </div>
                
                <div class="col-sm-3 comp-grid">
                    
                    <a  class="btn btn btn-primary btn-block" href="<?php print_link("ql_5_quotelist/add") ?>">
                        <i class="material-icons">add</i>                               
                        Add New Ql 5 Quotelist 
                    </a>
                    
                </div>
                
                <div class="col-sm-5 comp-grid">
                    
                    <form  class="search" method="get">
                        <div class="input-group">
                            <input value="<?php echo get_query_str_value('search'); ?>" class="form-control" type="text" name="search"  placeholder="Search" />
                                <div class="input-group-append">
                                    <button class="btn btn-primary"><i class="material-icons">search</i></button>
                                </div>
                            </div>
                        </form>
                        
                    </div>
                    
                    <div class="col-md-12 comp-grid">
                        <div class="">
                            <?php
                            if(!empty($field_name)){
                            ?>
                            <hr class='sm d-block d-sm-none' />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <li class="breadcrumb-item"><a class="text-capitalize" href="<?php print_link('ql_5_quotelist') ?>"><?php echo $field_name ?></a></li>
                                    <li  class="breadcrumb-item active text-capitalize"><?php echo urldecode($field_value) ?></li>
                                </ul>
                            </nav>
                            <?php 
                            }
                            elseif(!empty($_GET['search'])){
                            ?>
                            <hr class='sm d-block d-sm-none' />
                            <nav class="page-header-breadcrumbs mt-2" aria-label="breadcrumb">
                                <ul class="breadcrumb m-0 p-1">
                                    <li class="breadcrumb-item">
                                        <a class="text-capitalize" href="<?php print_link('ql_5_quotelist') ?>">&laquo; Back</a>
                                    </li>
                                    <li  class="breadcrumb-item active text-capitalize">Search <strong><?php echo $_GET['search']; ?></strong></li>
                                </ul>
                            </nav>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        
        <?php
        }
        ?>
        
        <div  class="">
            <div class="container">
                
                <div class="row ">
                    
                    <div class="col-md-12 comp-grid">
                        
                        <div  class="card animated fadeIn">
                            <div id="ql_5_quotelist-list-records">
                                <?php $this :: display_page_errors(); ?>
                                
                                
                                <?php
                                if(!empty($records)){
                                ?>
                                <div class="page-records table-responsive">
                                    <table class="table  table-striped table-sm">
                                        <thead class="table-header bg-light">
                                            <tr>
                                                <th class="td-sno td-checkbox"><input class="toggle-check-all" type="checkbox" /></th>
                                                
                                                <th class="td-sno">#</th>
                                                <th > Quotenum</th>
                                                <th > Dealer</th>
                                                <th > Tagname</th>
                                                <th > Quoteentry</th>
                                                <th > Quoter</th>
                                                <th > Salesrep</th>
                                                <th > Recdrfq</th>
                                                <th > Extraleadtime</th>
                                                <th > Value</th>
                                                <th > Senttoqe</th>
                                                <th > Senttodealer</th>
                                                <th > Comments</th>
                                                <th > Timestamp</th>
                                                <th > Originator</th>
                                                <th > Numrevisions</th>
                                                
                                                <th class="td-btn"></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <?php
                                            $counter = 0;
                                            foreach($records as $data){
                                            $counter++;
                                            ?>
                                            <tr>
                                                
                                                <th class=" td-checkbox">
                                                    <label>
                                                        <input class="optioncheck" name="optioncheck[]" value="<?php echo $data['QuoteNum'] ?>" type="checkbox" />
                                                        </label>
                                                    </th>
                                                    
                                                    <th class="td-sno"><?php echo $counter; ?></th>
                                                    <td><a href="<?php print_link('ql_5_quotelist/view/' . $data['QuoteNum']) ?>"><?php echo $data['QuoteNum']; ?></a></td>
                                                    <td> <?php echo $data['Dealer']; ?> </td>
                                                    <td> <?php echo $data['TagName']; ?> </td>
                                                    <td> <?php echo $data['QuoteEntry']; ?> </td>
                                                    <td> <?php echo $data['Quoter']; ?> </td>
                                                    <td> <?php echo $data['SalesRep']; ?> </td>
                                                    <td> <?php echo $data['RecdRFQ']; ?> </td>
                                                    <td> <?php echo $data['ExtraLeadTime']; ?> </td>
                                                    <td> <?php echo $data['Value']; ?> </td>
                                                    <td> <?php echo $data['SentToQE']; ?> </td>
                                                    <td> <?php echo $data['SentToDealer']; ?> </td>
                                                    <td> <?php echo $data['Comments']; ?> </td>
                                                    <td> <?php echo $data['TimeStamp']; ?> </td>
                                                    <td> <?php echo $data['Originator']; ?> </td>
                                                    <td> <?php echo $data['NumRevisions']; ?> </td>
                                                    
                                                    
                                                    <th class="td-btn">
                                                        
                                                        
                                                        <a class="btn btn-sm btn-success has-tooltip" title="View Record" href="<?php print_link('ql_5_quotelist/view/'.$data['QuoteNum']); ?>">
                                                            <i class="material-icons">visibility</i> View
                                                        </a>
                                                        
                                                        
                                                        <a class="btn btn-sm btn-info has-tooltip" title="Edit This Record" href="<?php print_link('ql_5_quotelist/edit/'.$data['QuoteNum']); ?>">
                                                            <i class="material-icons">edit</i> Edit
                                                        </a>
                                                        
                                                        
                                                        <a class="btn btn-sm btn-danger recordDeletePromptAction has-tooltip" title="Delete this record" href="<?php print_link("ql_5_quotelist/delete/$data[QuoteNum]"); ?>" data-prompt-msg="">
                                                            <i class="material-icons">clear</i>
                                                            Delete
                                                        </a>
                                                        
                                                        
                                                    </th>
                                                </tr>
                                                <?php 
                                                }
                                                ?>
                                                
                                            </tbody>
                                        </table>
                                    </div>
                                    <?php
                                    if( $show_footer == true ){
                                    ?>
                                    <div class="card-footer">
                                        <div class="">  
                                            
                                            <button data-prompt-msg="Are you sure you want to delete these records" data-url="<?php print_link("ql_5_quotelist/delete/{sel_ids}"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                                                <i class="material-icons">clear</i> Delete Selected
                                            </button>
                                            
                                            
                                            <button class="btn btn-sm btn-primary export-btn"><i class="material-icons">save</i> Export</button>
                                            
                                            
                                            <?php Html :: import_form('ql_5_quotelist/import_data' , "Import Data", 'CSV , JSON'); ?>
                                            
                                        </div>
                                        
                                        <?php
                                        if( $show_pagination == true ){
                                        $pager = new Pagination($total_records,$record_count);
                                        $pager->page_name='ql_5_quotelist';
                                        $pager->show_page_count=true;
                                        $pager->show_record_count=true;
                                        $pager->show_page_limit=true;
                                        $pager->show_page_number_list=true;
                                        $pager->pager_link_range=5;
                                        
                                        $pager->render();
                                        }
                                        ?>
                                        
                                    </div>
                                    <?php
                                    }
                                    }
                                    else{
                                    ?>
                                    <div class="text-muted animated bounce">
                                        <h4><i class="material-icons">block</i> Record not found</h4>
                                    </div>
                                    <?php
                                    }
                                    ?>
                                    
                                </div>
                            </div>
                            
                        </div>
                        
                    </div>
                </div>
            </div>
            
        </section>
        